/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.util.Strings;
import com.datastax.oss.protocol.internal.util.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class InetCodec
implements TypeCodec<InetAddress> {
    @Override
    @NonNull
    public GenericType<InetAddress> getJavaType() {
        return GenericType.INET_ADDRESS;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.INET;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        return value2 instanceof InetAddress;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return InetAddress.class.equals(javaClass);
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable InetAddress value2, @NonNull ProtocolVersion protocolVersion) {
        return value2 == null ? null : ByteBuffer.wrap(value2.getAddress());
    }

    @Override
    @Nullable
    public InetAddress decode(@Nullable ByteBuffer bytes2, @NonNull ProtocolVersion protocolVersion) {
        if (bytes2 == null || bytes2.remaining() == 0) {
            return null;
        }
        try {
            return InetAddress.getByAddress(Bytes.getArray(bytes2));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid bytes for inet value, got " + bytes2.remaining() + " bytes");
        }
    }

    @Override
    @NonNull
    public String format(@Nullable InetAddress value2) {
        return value2 == null ? "NULL" : "'" + value2.getHostAddress() + "'";
    }

    @Override
    @Nullable
    public InetAddress parse(@Nullable String value2) {
        if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (!Strings.isQuoted(value2 = value2.trim())) {
            throw new IllegalArgumentException(String.format("inet values must be enclosed in single quotes (\"%s\")", value2));
        }
        try {
            return InetAddress.getByName(value2.substring(1, value2.length() - 1));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Cannot parse inet value from \"%s\"", value2));
        }
    }
}

