/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveFloatCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class FloatCodec
implements PrimitiveFloatCodec {
    @Override
    @NonNull
    public GenericType<Float> getJavaType() {
        return GenericType.FLOAT;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.FLOAT;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        return value2 instanceof Float;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == Float.class || javaClass == Float.TYPE;
    }

    @Override
    @Nullable
    public ByteBuffer encodePrimitive(float value2, @NonNull ProtocolVersion protocolVersion) {
        ByteBuffer bytes2 = ByteBuffer.allocate(4);
        bytes2.putFloat(0, value2);
        return bytes2;
    }

    @Override
    public float decodePrimitive(@Nullable ByteBuffer bytes2, @NonNull ProtocolVersion protocolVersion) {
        if (bytes2 == null || bytes2.remaining() == 0) {
            return 0.0f;
        }
        if (bytes2.remaining() != 4) {
            throw new IllegalArgumentException("Invalid 32-bits float value, expecting 4 bytes but got " + bytes2.remaining());
        }
        return bytes2.getFloat(bytes2.position());
    }

    @Override
    @NonNull
    public String format(@Nullable Float value2) {
        return value2 == null ? "NULL" : Float.toString(value2.floatValue());
    }

    @Override
    @Nullable
    public Float parse(@Nullable String value2) {
        try {
            return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : Float.valueOf(Float.parseFloat(value2));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Cannot parse 32-bits float value from \"%s\"", value2));
        }
    }
}

