/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveDoubleCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DoubleCodec
implements PrimitiveDoubleCodec {
    @Override
    @NonNull
    public GenericType<Double> getJavaType() {
        return GenericType.DOUBLE;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.DOUBLE;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        return value2 instanceof Double;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == Double.class || javaClass == Double.TYPE;
    }

    @Override
    @Nullable
    public ByteBuffer encodePrimitive(double value2, @NonNull ProtocolVersion protocolVersion) {
        ByteBuffer bytes2 = ByteBuffer.allocate(8);
        bytes2.putDouble(0, value2);
        return bytes2;
    }

    @Override
    public double decodePrimitive(@Nullable ByteBuffer bytes2, @NonNull ProtocolVersion protocolVersion) {
        if (bytes2 == null || bytes2.remaining() == 0) {
            return 0.0;
        }
        if (bytes2.remaining() != 8) {
            throw new IllegalArgumentException("Invalid 64-bits double value, expecting 8 bytes but got " + bytes2.remaining());
        }
        return bytes2.getDouble(bytes2.position());
    }

    @Override
    @NonNull
    public String format(@Nullable Double value2) {
        return value2 == null ? "NULL" : Double.toString(value2);
    }

    @Override
    @Nullable
    public Double parse(@Nullable String value2) {
        try {
            return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : Double.valueOf(Double.parseDouble(value2));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Cannot parse 64-bits double value from \"%s\"", value2));
        }
    }
}

