/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DecimalCodec
implements TypeCodec<BigDecimal> {
    @Override
    @NonNull
    public GenericType<BigDecimal> getJavaType() {
        return GenericType.BIG_DECIMAL;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.DECIMAL;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        return value2 instanceof BigDecimal;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return BigDecimal.class.isAssignableFrom(javaClass);
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable BigDecimal value2, @NonNull ProtocolVersion protocolVersion) {
        if (value2 == null) {
            return null;
        }
        BigInteger bi = value2.unscaledValue();
        int scale = value2.scale();
        byte[] bibytes = bi.toByteArray();
        ByteBuffer bytes2 = ByteBuffer.allocate(4 + bibytes.length);
        bytes2.putInt(scale);
        bytes2.put(bibytes);
        bytes2.rewind();
        return bytes2;
    }

    @Override
    @Nullable
    public BigDecimal decode(@Nullable ByteBuffer bytes2, @NonNull ProtocolVersion protocolVersion) {
        if (bytes2 == null || bytes2.remaining() == 0) {
            return null;
        }
        if (bytes2.remaining() < 4) {
            throw new IllegalArgumentException("Invalid decimal value, expecting at least 4 bytes but got " + bytes2.remaining());
        }
        bytes2 = bytes2.duplicate();
        int scale = bytes2.getInt();
        byte[] bibytes = new byte[bytes2.remaining()];
        bytes2.get(bibytes);
        BigInteger bi = new BigInteger(bibytes);
        return new BigDecimal(bi, scale);
    }

    @Override
    @NonNull
    public String format(@Nullable BigDecimal value2) {
        return value2 == null ? "NULL" : value2.toString();
    }

    @Override
    @Nullable
    public BigDecimal parse(@Nullable String value2) {
        try {
            return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : new BigDecimal(value2);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Cannot parse decimal value from \"%s\"", value2));
        }
    }
}

