/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.util.Strings;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DateCodec
implements TypeCodec<LocalDate> {
    private static final LocalDate EPOCH = LocalDate.of(1970, 1, 1);
    private static final long MAX_CQL_LONG_VALUE = 0xFFFFFFFFL;
    private static final long EPOCH_AS_CQL_LONG = 0x80000000L;

    @Override
    @NonNull
    public GenericType<LocalDate> getJavaType() {
        return GenericType.LOCAL_DATE;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.DATE;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        return value2 instanceof LocalDate;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == LocalDate.class;
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable LocalDate value2, @NonNull ProtocolVersion protocolVersion) {
        if (value2 == null) {
            return null;
        }
        long days = ChronoUnit.DAYS.between(EPOCH, value2);
        int unsigned = DateCodec.signedToUnsigned((int)days);
        return TypeCodecs.INT.encodePrimitive(unsigned, protocolVersion);
    }

    @Override
    @Nullable
    public LocalDate decode(@Nullable ByteBuffer bytes2, @NonNull ProtocolVersion protocolVersion) {
        if (bytes2 == null || bytes2.remaining() == 0) {
            return null;
        }
        int unsigned = TypeCodecs.INT.decodePrimitive(bytes2, protocolVersion);
        int signed = DateCodec.unsignedToSigned(unsigned);
        return EPOCH.plusDays(signed);
    }

    @Override
    @NonNull
    public String format(@Nullable LocalDate value2) {
        return value2 == null ? "NULL" : Strings.quote(DateTimeFormatter.ISO_LOCAL_DATE.format(value2));
    }

    @Override
    @Nullable
    public LocalDate parse(@Nullable String value2) {
        if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (Strings.isQuoted(value2)) {
            value2 = Strings.unquote(value2);
        }
        if (Strings.isLongLiteral(value2)) {
            int days;
            long raw2;
            try {
                raw2 = Long.parseLong(value2);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Cannot parse date value from \"%s\"", value2));
            }
            try {
                days = DateCodec.cqlDateToDaysSinceEpoch(raw2);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Cannot parse date value from \"%s\"", value2));
            }
            return EPOCH.plusDays(days);
        }
        try {
            return LocalDate.parse(value2, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(String.format("Cannot parse date value from \"%s\"", value2));
        }
    }

    private static int signedToUnsigned(int signed) {
        return signed - Integer.MIN_VALUE;
    }

    private static int unsignedToSigned(int unsigned) {
        return unsigned + Integer.MIN_VALUE;
    }

    private static int cqlDateToDaysSinceEpoch(long raw2) {
        if (raw2 < 0L || raw2 > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(String.format("Numeric literals for DATE must be between 0 and %d (got %d)", 0xFFFFFFFFL, raw2));
        }
        return (int)(raw2 - 0x80000000L);
    }
}

