/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.CustomType;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.protocol.internal.util.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class CustomCodec
implements TypeCodec<ByteBuffer> {
    private final CustomType cqlType;

    public CustomCodec(CustomType cqlType) {
        this.cqlType = cqlType;
    }

    @Override
    @NonNull
    public GenericType<ByteBuffer> getJavaType() {
        return GenericType.BYTE_BUFFER;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return this.cqlType;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        return value2 instanceof ByteBuffer;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return ByteBuffer.class.equals(javaClass);
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable ByteBuffer value2, @NonNull ProtocolVersion protocolVersion) {
        return value2 == null ? null : value2.duplicate();
    }

    @Override
    @Nullable
    public ByteBuffer decode(@Nullable ByteBuffer bytes2, @NonNull ProtocolVersion protocolVersion) {
        return bytes2 == null ? null : bytes2.duplicate();
    }

    @Override
    @NonNull
    public String format(@Nullable ByteBuffer value2) {
        return value2 == null ? "NULL" : Bytes.toHexString(value2);
    }

    @Override
    @Nullable
    public ByteBuffer parse(@Nullable String value2) {
        return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : Bytes.fromHexString(value2);
    }
}

