/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.util.VIntCoding;
import com.datastax.oss.driver.shaded.guava.common.io.ByteArrayDataInput;
import com.datastax.oss.driver.shaded.guava.common.io.ByteArrayDataOutput;
import com.datastax.oss.driver.shaded.guava.common.io.ByteStreams;
import com.datastax.oss.protocol.internal.util.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class CqlDurationCodec
implements TypeCodec<CqlDuration> {
    @Override
    @NonNull
    public GenericType<CqlDuration> getJavaType() {
        return GenericType.CQL_DURATION;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.DURATION;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        return value2 instanceof CqlDuration;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == CqlDuration.class;
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable CqlDuration value2, @NonNull ProtocolVersion protocolVersion) {
        if (value2 == null) {
            return null;
        }
        long months = value2.getMonths();
        long days = value2.getDays();
        long nanoseconds = value2.getNanoseconds();
        int size2 = VIntCoding.computeVIntSize(months) + VIntCoding.computeVIntSize(days) + VIntCoding.computeVIntSize(nanoseconds);
        ByteArrayDataOutput out = ByteStreams.newDataOutput(size2);
        try {
            VIntCoding.writeVInt(months, out);
            VIntCoding.writeVInt(days, out);
            VIntCoding.writeVInt(nanoseconds, out);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
        return ByteBuffer.wrap(out.toByteArray());
    }

    @Override
    @Nullable
    public CqlDuration decode(@Nullable ByteBuffer bytes2, @NonNull ProtocolVersion protocolVersion) {
        if (bytes2 == null || bytes2.remaining() == 0) {
            return null;
        }
        ByteArrayDataInput in = ByteStreams.newDataInput(Bytes.getArray(bytes2));
        try {
            int months = (int)VIntCoding.readVInt(in);
            int days = (int)VIntCoding.readVInt(in);
            long nanoseconds = VIntCoding.readVInt(in);
            return CqlDuration.newInstance(months, days, nanoseconds);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    @Override
    @NonNull
    public String format(@Nullable CqlDuration value2) {
        return value2 == null ? "NULL" : value2.toString();
    }

    @Override
    @Nullable
    public CqlDuration parse(@Nullable String value2) {
        return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : CqlDuration.from(value2);
    }
}

