/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveBooleanCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class BooleanCodec
implements PrimitiveBooleanCodec {
    private static final ByteBuffer TRUE = ByteBuffer.wrap(new byte[]{1});
    private static final ByteBuffer FALSE = ByteBuffer.wrap(new byte[]{0});

    @Override
    @NonNull
    public GenericType<Boolean> getJavaType() {
        return GenericType.BOOLEAN;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.BOOLEAN;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        return value2 instanceof Boolean;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == Boolean.class || javaClass == Boolean.TYPE;
    }

    @Override
    @Nullable
    public ByteBuffer encodePrimitive(boolean value2, @NonNull ProtocolVersion protocolVersion) {
        return value2 ? TRUE.duplicate() : FALSE.duplicate();
    }

    @Override
    public boolean decodePrimitive(@Nullable ByteBuffer bytes2, @NonNull ProtocolVersion protocolVersion) {
        if (bytes2 == null || bytes2.remaining() == 0) {
            return false;
        }
        if (bytes2.remaining() != 1) {
            throw new IllegalArgumentException("Invalid boolean value, expecting 1 byte but got " + bytes2.remaining());
        }
        return bytes2.get(bytes2.position()) != 0;
    }

    @Override
    @NonNull
    public String format(@Nullable Boolean value2) {
        if (value2 == null) {
            return "NULL";
        }
        return value2 != false ? "true" : "false";
    }

    @Override
    @Nullable
    public Boolean parse(@Nullable String value2) {
        if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (value2.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return false;
        }
        if (value2.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return true;
        }
        throw new IllegalArgumentException(String.format("Cannot parse boolean value from \"%s\"", value2));
    }
}

