/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveLongCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class BigIntCodec
implements PrimitiveLongCodec {
    @Override
    @NonNull
    public GenericType<Long> getJavaType() {
        return GenericType.LONG;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.BIGINT;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        return value2 instanceof Long;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == Long.class || javaClass == Long.TYPE;
    }

    @Override
    @Nullable
    public ByteBuffer encodePrimitive(long value2, @NonNull ProtocolVersion protocolVersion) {
        ByteBuffer bytes2 = ByteBuffer.allocate(8);
        bytes2.putLong(0, value2);
        return bytes2;
    }

    @Override
    public long decodePrimitive(@Nullable ByteBuffer bytes2, @NonNull ProtocolVersion protocolVersion) {
        if (bytes2 == null || bytes2.remaining() == 0) {
            return 0L;
        }
        if (bytes2.remaining() != 8) {
            throw new IllegalArgumentException("Invalid 64-bits long value, expecting 8 bytes but got " + bytes2.remaining());
        }
        return bytes2.getLong(bytes2.position());
    }

    @Override
    @NonNull
    public String format(@Nullable Long value2) {
        return value2 == null ? "NULL" : Long.toString(value2);
    }

    @Override
    @Nullable
    public Long parse(@Nullable String value2) {
        try {
            return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : Long.valueOf(Long.parseLong(value2));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Cannot parse 64-bits long value from \"%s\"", value2));
        }
    }
}

