/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type;

import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.CustomType;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultCustomType
implements CustomType,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String className;

    public DefaultCustomType(@NonNull String className2) {
        Preconditions.checkNotNull(className2);
        this.className = className2;
    }

    @Override
    @NonNull
    public String getClassName() {
        return this.className;
    }

    @Override
    public boolean isDetached() {
        return false;
    }

    @Override
    public void attach(@NonNull AttachmentPoint attachmentPoint) {
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof CustomType) {
            CustomType that = (CustomType)other;
            return this.className.equals(that.getClassName());
        }
        return false;
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    public String toString() {
        return "Custom(" + this.className + ")";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Preconditions.checkNotNull(this.className);
    }
}

