/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.time;

import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.time.Clock;
import com.datastax.oss.driver.internal.core.time.MonotonicTimestampGenerator;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ThreadLocalTimestampGenerator
extends MonotonicTimestampGenerator {
    private final ThreadLocal<Long> lastRef = ThreadLocal.withInitial(() -> 0L);

    public ThreadLocalTimestampGenerator(DriverContext context) {
        super(context);
    }

    @VisibleForTesting
    ThreadLocalTimestampGenerator(Clock clock, DriverContext context) {
        super(clock, context);
    }

    @Override
    public long next() {
        Long last2 = this.lastRef.get();
        long next2 = this.computeNext(last2);
        this.lastRef.set(next2);
        return next2;
    }
}

