/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.retry;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.connection.ClosedConnectionException;
import com.datastax.oss.driver.api.core.connection.HeartbeatException;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.retry.RetryDecision;
import com.datastax.oss.driver.api.core.retry.RetryPolicy;
import com.datastax.oss.driver.api.core.servererrors.CoordinatorException;
import com.datastax.oss.driver.api.core.servererrors.DefaultWriteType;
import com.datastax.oss.driver.api.core.servererrors.ReadFailureException;
import com.datastax.oss.driver.api.core.servererrors.WriteFailureException;
import com.datastax.oss.driver.api.core.servererrors.WriteType;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultRetryPolicy
implements RetryPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRetryPolicy.class);
    @VisibleForTesting
    public static final String RETRYING_ON_READ_TIMEOUT = "[{}] Retrying on read timeout on same host (consistency: {}, required responses: {}, received responses: {}, data retrieved: {}, retries: {})";
    @VisibleForTesting
    public static final String RETRYING_ON_WRITE_TIMEOUT = "[{}] Retrying on write timeout on same host (consistency: {}, write type: {}, required acknowledgments: {}, received acknowledgments: {}, retries: {})";
    @VisibleForTesting
    public static final String RETRYING_ON_UNAVAILABLE = "[{}] Retrying on unavailable exception on next host (consistency: {}, required replica: {}, alive replica: {}, retries: {})";
    @VisibleForTesting
    public static final String RETRYING_ON_ABORTED = "[{}] Retrying on aborted request on next host (retries: {})";
    @VisibleForTesting
    public static final String RETRYING_ON_ERROR = "[{}] Retrying on node error on next host (retries: {})";
    private final String logPrefix;

    public DefaultRetryPolicy(DriverContext context, String profileName) {
        this.logPrefix = (context != null ? context.getSessionName() : null) + "|" + profileName;
    }

    @Override
    public RetryDecision onReadTimeout(@NonNull Request request, @NonNull ConsistencyLevel cl, int blockFor, int received, boolean dataPresent, int retryCount) {
        RetryDecision decision;
        RetryDecision retryDecision = decision = retryCount == 0 && received >= blockFor && !dataPresent ? RetryDecision.RETRY_SAME : RetryDecision.RETHROW;
        if (decision == RetryDecision.RETRY_SAME && LOG.isTraceEnabled()) {
            LOG.trace(RETRYING_ON_READ_TIMEOUT, this.logPrefix, cl, blockFor, received, false, retryCount);
        }
        return decision;
    }

    @Override
    public RetryDecision onWriteTimeout(@NonNull Request request, @NonNull ConsistencyLevel cl, @NonNull WriteType writeType, int blockFor, int received, int retryCount) {
        RetryDecision decision;
        RetryDecision retryDecision = decision = retryCount == 0 && writeType == DefaultWriteType.BATCH_LOG ? RetryDecision.RETRY_SAME : RetryDecision.RETHROW;
        if (decision == RetryDecision.RETRY_SAME && LOG.isTraceEnabled()) {
            LOG.trace(RETRYING_ON_WRITE_TIMEOUT, this.logPrefix, cl, writeType, blockFor, received, retryCount);
        }
        return decision;
    }

    @Override
    public RetryDecision onUnavailable(@NonNull Request request, @NonNull ConsistencyLevel cl, int required, int alive, int retryCount) {
        RetryDecision decision;
        RetryDecision retryDecision = decision = retryCount == 0 ? RetryDecision.RETRY_NEXT : RetryDecision.RETHROW;
        if (decision == RetryDecision.RETRY_NEXT && LOG.isTraceEnabled()) {
            LOG.trace(RETRYING_ON_UNAVAILABLE, this.logPrefix, cl, required, alive, retryCount);
        }
        return decision;
    }

    @Override
    public RetryDecision onRequestAborted(@NonNull Request request, @NonNull Throwable error2, int retryCount) {
        RetryDecision decision;
        RetryDecision retryDecision = decision = error2 instanceof ClosedConnectionException || error2 instanceof HeartbeatException ? RetryDecision.RETRY_NEXT : RetryDecision.RETHROW;
        if (decision == RetryDecision.RETRY_NEXT && LOG.isTraceEnabled()) {
            LOG.trace(RETRYING_ON_ABORTED, this.logPrefix, retryCount, error2);
        }
        return decision;
    }

    @Override
    public RetryDecision onErrorResponse(@NonNull Request request, @NonNull CoordinatorException error2, int retryCount) {
        RetryDecision decision;
        RetryDecision retryDecision = decision = error2 instanceof ReadFailureException || error2 instanceof WriteFailureException ? RetryDecision.RETHROW : RetryDecision.RETRY_NEXT;
        if (decision == RetryDecision.RETRY_NEXT && LOG.isTraceEnabled()) {
            LOG.trace(RETRYING_ON_ERROR, this.logPrefix, retryCount, error2);
        }
        return decision;
    }

    @Override
    public void close() {
    }
}

