/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.protocol;

import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.protocol.ByteBufCompressor;
import com.datastax.oss.driver.internal.core.util.DependencyCheck;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;
import org.xerial.snappy.Snappy;

@ThreadSafe
public class SnappyCompressor
extends ByteBufCompressor {
    public SnappyCompressor(DriverContext context) {
        if (!DependencyCheck.SNAPPY.isPresent()) {
            throw new IllegalStateException("Could not find the Snappy library on the classpath (the driver declares it as an optional dependency, so you need to declare it explicitly)");
        }
    }

    @Override
    public String algorithm() {
        return "snappy";
    }

    @Override
    protected ByteBuf compressDirect(ByteBuf input2, boolean prependWithUncompressedLength) {
        int maxCompressedLength = Snappy.maxCompressedLength(input2.readableBytes());
        ByteBuf output = input2.alloc().directBuffer(maxCompressedLength);
        try {
            ByteBuffer in = SnappyCompressor.inputNioBuffer(input2);
            input2.readerIndex(input2.writerIndex());
            ByteBuffer out = SnappyCompressor.outputNioBuffer(output);
            int written = Snappy.compress(in, out);
            output.writerIndex(output.writerIndex() + written);
            return output;
        }
        catch (IOException e) {
            output.release();
            throw new RuntimeException(e);
        }
    }

    @Override
    protected ByteBuf compressHeap(ByteBuf input2, boolean prependWithUncompressedLength) {
        int maxCompressedLength = Snappy.maxCompressedLength(input2.readableBytes());
        int inOffset = input2.arrayOffset() + input2.readerIndex();
        byte[] in = input2.array();
        int len = input2.readableBytes();
        input2.readerIndex(input2.writerIndex());
        ByteBuf output = input2.alloc().heapBuffer(maxCompressedLength);
        try {
            int offset = output.arrayOffset() + output.writerIndex();
            byte[] out = output.array();
            int written = Snappy.compress(in, inOffset, len, out, offset);
            output.writerIndex(output.writerIndex() + written);
            return output;
        }
        catch (IOException e) {
            output.release();
            throw new RuntimeException(e);
        }
    }

    @Override
    protected int readUncompressedLength(ByteBuf compressed) {
        return -1;
    }

    @Override
    protected ByteBuf decompressDirect(ByteBuf input2, int uncompressedLength) {
        ByteBuffer in = SnappyCompressor.inputNioBuffer(input2);
        input2.readerIndex(input2.writerIndex());
        ReferenceCounted output = null;
        try {
            if (!Snappy.isValidCompressedBuffer(in)) {
                throw new IllegalArgumentException("Provided frame does not appear to be Snappy compressed");
            }
            output = input2.alloc().directBuffer(Snappy.uncompressedLength(in));
            ByteBuffer out = SnappyCompressor.outputNioBuffer((ByteBuf)output);
            int size2 = Snappy.uncompress(in, out);
            ((ByteBuf)output).writerIndex(((ByteBuf)output).writerIndex() + size2);
            return output;
        }
        catch (IOException e) {
            if (output != null) {
                output.release();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    protected ByteBuf decompressHeap(ByteBuf input2, int uncompressedLength) {
        int inOffset = input2.arrayOffset() + input2.readerIndex();
        byte[] in = input2.array();
        int len = input2.readableBytes();
        input2.readerIndex(input2.writerIndex());
        ReferenceCounted output = null;
        try {
            if (!Snappy.isValidCompressedBuffer(in, inOffset, len)) {
                throw new IllegalArgumentException("Provided frame does not appear to be Snappy compressed");
            }
            output = input2.alloc().heapBuffer(Snappy.uncompressedLength(in, inOffset, len));
            int offset = ((ByteBuf)output).arrayOffset() + ((ByteBuf)output).writerIndex();
            byte[] out = ((ByteBuf)output).array();
            int written = Snappy.uncompress(in, inOffset, len, out, offset);
            ((ByteBuf)output).writerIndex(((ByteBuf)output).writerIndex() + written);
            return output;
        }
        catch (IOException e) {
            if (output != null) {
                output.release();
            }
            throw new RuntimeException(e);
        }
    }
}

