/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.protocol;

import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.protocol.ByteBufCompressor;
import com.datastax.oss.driver.internal.core.util.DependencyCheck;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class Lz4Compressor
extends ByteBufCompressor {
    private static final Logger LOG = LoggerFactory.getLogger(Lz4Compressor.class);
    private final LZ4Compressor compressor;
    private final LZ4FastDecompressor decompressor;

    public Lz4Compressor(DriverContext context) {
        this(context.getSessionName());
    }

    @VisibleForTesting
    Lz4Compressor(String sessionName) {
        if (!DependencyCheck.LZ4.isPresent()) {
            throw new IllegalStateException("Could not find the LZ4 library on the classpath (the driver declares it as an optional dependency, so you need to declare it explicitly)");
        }
        LZ4Factory lz4Factory = LZ4Factory.fastestInstance();
        LOG.info("[{}] Using {}", (Object)sessionName, (Object)lz4Factory.toString());
        this.compressor = lz4Factory.fastCompressor();
        this.decompressor = lz4Factory.fastDecompressor();
    }

    @Override
    public String algorithm() {
        return "lz4";
    }

    @Override
    protected ByteBuf compressDirect(ByteBuf input2, boolean prependWithUncompressedLength) {
        int maxCompressedLength = this.compressor.maxCompressedLength(input2.readableBytes());
        ByteBuf output = input2.alloc().directBuffer((prependWithUncompressedLength ? 4 : 0) + maxCompressedLength);
        try {
            ByteBuffer in = Lz4Compressor.inputNioBuffer(input2);
            input2.readerIndex(input2.writerIndex());
            if (prependWithUncompressedLength) {
                output.writeInt(in.remaining());
            }
            ByteBuffer out = Lz4Compressor.outputNioBuffer(output);
            int written = this.compressor.compress(in, in.position(), in.remaining(), out, out.position(), out.remaining());
            output.writerIndex(output.writerIndex() + written);
        }
        catch (Exception e) {
            output.release();
            throw e;
        }
        return output;
    }

    @Override
    protected ByteBuf compressHeap(ByteBuf input2, boolean prependWithUncompressedLength) {
        int maxCompressedLength = this.compressor.maxCompressedLength(input2.readableBytes());
        int inOffset = input2.arrayOffset() + input2.readerIndex();
        byte[] in = input2.array();
        int len = input2.readableBytes();
        input2.readerIndex(input2.writerIndex());
        ByteBuf output = input2.alloc().heapBuffer((prependWithUncompressedLength ? 4 : 0) + maxCompressedLength);
        try {
            if (prependWithUncompressedLength) {
                output.writeInt(len);
            }
            int offset = output.arrayOffset() + output.writerIndex();
            byte[] out = output.array();
            int written = this.compressor.compress(in, inOffset, len, out, offset);
            output.writerIndex(output.writerIndex() + written);
        }
        catch (Exception e) {
            output.release();
            throw e;
        }
        return output;
    }

    @Override
    protected int readUncompressedLength(ByteBuf compressed) {
        return compressed.readInt();
    }

    @Override
    protected ByteBuf decompressDirect(ByteBuf input2, int uncompressedLength) {
        int readable = input2.readableBytes();
        ByteBuffer in = Lz4Compressor.inputNioBuffer(input2);
        input2.readerIndex(input2.writerIndex());
        ByteBuf output = input2.alloc().directBuffer(uncompressedLength);
        try {
            ByteBuffer out = Lz4Compressor.outputNioBuffer(output);
            int read = this.decompressor.decompress(in, in.position(), out, out.position(), out.remaining());
            if (read != readable) {
                throw new IllegalArgumentException("Compressed lengths mismatch");
            }
            output.writerIndex(output.writerIndex() + uncompressedLength);
        }
        catch (Exception e) {
            output.release();
            throw e;
        }
        return output;
    }

    @Override
    protected ByteBuf decompressHeap(ByteBuf input2, int uncompressedLength) {
        byte[] in = input2.array();
        int len = input2.readableBytes();
        int inOffset = input2.arrayOffset() + input2.readerIndex();
        input2.readerIndex(input2.writerIndex());
        ByteBuf output = input2.alloc().heapBuffer(uncompressedLength);
        try {
            int offset = output.arrayOffset() + output.writerIndex();
            byte[] out = output.array();
            int read = this.decompressor.decompress(in, inOffset, out, offset, uncompressedLength);
            if (read != len) {
                throw new IllegalArgumentException("Compressed lengths mismatch");
            }
            output.writerIndex(output.writerIndex() + uncompressedLength);
        }
        catch (Exception e) {
            output.release();
            throw e;
        }
        return output;
    }
}

