/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.metadata.token.TokenRange;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public abstract class TokenRangeBase
implements TokenRange {
    private final Token start;
    private final Token end;
    private final Token minToken;

    protected TokenRangeBase(Token start, Token end, Token minToken) {
        this.start = start;
        this.end = end;
        this.minToken = minToken;
    }

    @Override
    @NonNull
    public Token getStart() {
        return this.start;
    }

    @Override
    @NonNull
    public Token getEnd() {
        return this.end;
    }

    @Override
    @NonNull
    public List<TokenRange> splitEvenly(int numberOfSplits) {
        if (numberOfSplits < 1) {
            throw new IllegalArgumentException(String.format("numberOfSplits (%d) must be greater than 0.", numberOfSplits));
        }
        if (this.isEmpty()) {
            throw new IllegalArgumentException("Can't split empty range " + this);
        }
        ArrayList<TokenRange> tokenRanges = new ArrayList<TokenRange>();
        List<Token> splitPoints = this.split(this.start, this.end, numberOfSplits);
        Token splitStart = this.start;
        for (Token splitEnd : splitPoints) {
            tokenRanges.add(this.newTokenRange(splitStart, splitEnd));
            splitStart = splitEnd;
        }
        tokenRanges.add(this.newTokenRange(splitStart, this.end));
        return tokenRanges;
    }

    protected abstract List<Token> split(Token var1, Token var2, int var3);

    protected List<BigInteger> split(BigInteger start, BigInteger range2, BigInteger ringEnd, BigInteger ringLength, int numberOfSplits) {
        BigInteger[] tmp = range2.divideAndRemainder(BigInteger.valueOf(numberOfSplits));
        BigInteger divider = tmp[0];
        int remainder = tmp[1].intValue();
        ArrayList<BigInteger> results2 = Lists.newArrayListWithExpectedSize(numberOfSplits - 1);
        BigInteger current = start;
        BigInteger dividerPlusOne = remainder == 0 ? null : divider.add(BigInteger.ONE);
        for (int i = 1; i < numberOfSplits; ++i) {
            current = current.add(remainder-- > 0 ? dividerPlusOne : divider);
            if (ringEnd != null && current.compareTo(ringEnd) > 0) {
                current = current.subtract(ringLength);
            }
            results2.add(current);
        }
        return results2;
    }

    protected abstract TokenRange newTokenRange(Token var1, Token var2);

    @Override
    public boolean isEmpty() {
        return this.start.equals(this.end) && !this.start.equals(this.minToken);
    }

    @Override
    public boolean isWrappedAround() {
        return this.start.compareTo(this.end) > 0 && !this.end.equals(this.minToken);
    }

    @Override
    public boolean isFullRing() {
        return this.start.equals(this.minToken) && this.end.equals(this.minToken);
    }

    @Override
    @NonNull
    public List<TokenRange> unwrap() {
        if (this.isWrappedAround()) {
            return ImmutableList.of(this.newTokenRange(this.start, this.minToken), this.newTokenRange(this.minToken, this.end));
        }
        return ImmutableList.of(this);
    }

    @Override
    public boolean intersects(@NonNull TokenRange that) {
        if (this.isEmpty() || that.isEmpty()) {
            return false;
        }
        return this.contains(this, that.getStart(), true) || this.contains(this, that.getEnd(), false) || this.contains(that, this.start, true) || this.contains(that, this.end, false);
    }

    @Override
    @NonNull
    public List<TokenRange> intersectWith(@NonNull TokenRange that) {
        if (!this.intersects(that)) {
            throw new IllegalArgumentException("The two ranges do not intersect, use intersects() before calling this method");
        }
        ArrayList<TokenRange> intersected = Lists.newArrayList();
        List<TokenRange> unwrappedForThis = this.unwrap();
        List<TokenRange> unwrappedForThat = that.unwrap();
        for (TokenRange t1 : unwrappedForThis) {
            for (TokenRange t2 : unwrappedForThat) {
                if (!t1.intersects(t2)) continue;
                intersected.add(this.newTokenRange(this.contains(t1, t2.getStart(), true) ? t2.getStart() : t1.getStart(), this.contains(t1, t2.getEnd(), false) ? t2.getEnd() : t1.getEnd()));
            }
        }
        if (intersected.size() == 2) {
            TokenRange t1 = (TokenRange)intersected.get(0);
            TokenRange t2 = (TokenRange)intersected.get(1);
            if (t1.getEnd().equals(t2.getStart()) || t2.getEnd().equals(t1.getStart())) {
                return ImmutableList.of(t1.mergeWith(t2));
            }
        }
        return intersected;
    }

    @Override
    public boolean contains(@NonNull Token token2) {
        return this.contains(this, token2, false);
    }

    @VisibleForTesting
    boolean contains(TokenRange range2, Token token2, boolean isStart) {
        boolean isBeforeEnd;
        boolean isAfterStart;
        if (range2.isEmpty()) {
            return false;
        }
        if (range2.getEnd().equals(this.minToken)) {
            if (range2.getStart().equals(this.minToken)) {
                return true;
            }
            if (token2.equals(this.minToken)) {
                return !isStart;
            }
            return isStart ? token2.compareTo(range2.getStart()) >= 0 : token2.compareTo(range2.getStart()) > 0;
        }
        boolean bl = isStart ? token2.compareTo(range2.getStart()) >= 0 : (isAfterStart = token2.compareTo(range2.getStart()) > 0);
        boolean bl2 = isStart ? token2.compareTo(range2.getEnd()) < 0 : (isBeforeEnd = token2.compareTo(range2.getEnd()) <= 0);
        return range2.isWrappedAround() ? isAfterStart || isBeforeEnd : isAfterStart && isBeforeEnd;
    }

    @Override
    @NonNull
    public TokenRange mergeWith(@NonNull TokenRange that) {
        boolean thatStartsInThis;
        if (this.equals(that)) {
            return this;
        }
        if (!(this.intersects(that) || this.end.equals(that.getStart()) || that.getEnd().equals(this.start))) {
            throw new IllegalArgumentException(String.format("Can't merge %s with %s because they neither intersect nor are adjacent", this, that));
        }
        if (this.isEmpty()) {
            return that;
        }
        if (that.isEmpty()) {
            return this;
        }
        boolean thisStartsInThat = this.contains(that, this.start, true) || this.start.equals(that.getEnd());
        boolean bl = thatStartsInThis = this.contains(this, that.getStart(), true) || that.getStart().equals(this.end);
        if (thisStartsInThat && thatStartsInThis) {
            return this.fullRing();
        }
        Token mergedEnd = thatStartsInThis && !this.contains(this, that.getEnd(), false) ? that.getEnd() : this.end;
        Token mergedStart = thisStartsInThat ? that.getStart() : this.start;
        return this.newTokenRange(mergedStart, mergedEnd);
    }

    private TokenRange fullRing() {
        return this.newTokenRange(this.minToken, this.minToken);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TokenRange) {
            TokenRange that = (TokenRange)other;
            return this.start.equals(that.getStart()) && this.end.equals(that.getEnd());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    @Override
    public int compareTo(@NonNull TokenRange that) {
        if (this.equals(that)) {
            return 0;
        }
        int compareStart = this.start.compareTo(that.getStart());
        return compareStart != 0 ? compareStart : this.end.compareTo(that.getEnd());
    }

    public String toString() {
        return String.format("%s(%s, %s)", this.getClass().getSimpleName(), this.start, this.end);
    }
}

