/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.metadata.token.TokenRange;
import com.datastax.oss.driver.internal.core.metadata.token.RandomToken;
import com.datastax.oss.driver.internal.core.metadata.token.RandomTokenFactory;
import com.datastax.oss.driver.internal.core.metadata.token.TokenRangeBase;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public class RandomTokenRange
extends TokenRangeBase {
    private static final BigInteger RING_LENGTH = RandomTokenFactory.MAX_VALUE.add(BigInteger.ONE);

    public RandomTokenRange(RandomToken start, RandomToken end) {
        super(start, end, RandomTokenFactory.MIN_TOKEN);
    }

    @Override
    protected TokenRange newTokenRange(Token start, Token end) {
        return new RandomTokenRange((RandomToken)start, (RandomToken)end);
    }

    @Override
    protected List<Token> split(Token startToken, Token endToken, int numberOfSplits) {
        if (startToken.equals(endToken) && startToken.equals(RandomTokenFactory.MIN_TOKEN)) {
            endToken = RandomTokenFactory.MAX_TOKEN;
        }
        BigInteger start = ((RandomToken)startToken).getValue();
        BigInteger end = ((RandomToken)endToken).getValue();
        BigInteger range2 = end.subtract(start);
        if (range2.compareTo(BigInteger.ZERO) < 0) {
            range2 = range2.add(RING_LENGTH);
        }
        List<BigInteger> values2 = super.split(start, range2, RandomTokenFactory.MAX_VALUE, RING_LENGTH, numberOfSplits);
        ArrayList<Token> tokens = Lists.newArrayListWithExpectedSize(values2.size());
        for (BigInteger value2 : values2) {
            tokens.add(new RandomToken(value2));
        }
        return tokens;
    }
}

