/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.metadata.token.TokenRange;
import com.datastax.oss.driver.internal.core.metadata.token.RandomToken;
import com.datastax.oss.driver.internal.core.metadata.token.RandomTokenRange;
import com.datastax.oss.driver.internal.core.metadata.token.TokenFactory;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RandomTokenFactory
implements TokenFactory {
    public static final String PARTITIONER_NAME = "org.apache.cassandra.dht.RandomPartitioner";
    private static final BigInteger MIN_VALUE = BigInteger.ONE.negate();
    static final BigInteger MAX_VALUE = BigInteger.valueOf(2L).pow(127);
    public static final RandomToken MIN_TOKEN = new RandomToken(MIN_VALUE);
    public static final RandomToken MAX_TOKEN = new RandomToken(MAX_VALUE);
    private final MessageDigest prototype = RandomTokenFactory.createMessageDigest();
    private final boolean supportsClone;

    public RandomTokenFactory() {
        boolean supportsClone;
        try {
            this.prototype.clone();
            supportsClone = true;
        }
        catch (CloneNotSupportedException e) {
            supportsClone = false;
        }
        this.supportsClone = supportsClone;
    }

    @Override
    public String getPartitionerName() {
        return PARTITIONER_NAME;
    }

    @Override
    public Token hash(ByteBuffer partitionKey) {
        return new RandomToken(this.md5(partitionKey));
    }

    @Override
    public Token parse(String tokenString) {
        return new RandomToken(new BigInteger(tokenString));
    }

    @Override
    public String format(Token token2) {
        Preconditions.checkArgument(token2 instanceof RandomToken, "Can only format RandomToken instances");
        return ((RandomToken)token2).getValue().toString();
    }

    @Override
    public Token minToken() {
        return MIN_TOKEN;
    }

    @Override
    public TokenRange range(Token start, Token end) {
        Preconditions.checkArgument(start instanceof RandomToken && end instanceof RandomToken, "Can only build ranges of RandomToken instances");
        return new RandomTokenRange((RandomToken)start, (RandomToken)end);
    }

    private static MessageDigest createMessageDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 doesn't seem to be available on this JVM", e);
        }
    }

    private BigInteger md5(ByteBuffer data2) {
        MessageDigest digest = this.newMessageDigest();
        digest.update(data2.duplicate());
        return new BigInteger(digest.digest()).abs();
    }

    private MessageDigest newMessageDigest() {
        if (this.supportsClone) {
            try {
                return (MessageDigest)this.prototype.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return RandomTokenFactory.createMessageDigest();
    }
}

