/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.metadata.token.TokenRange;
import com.datastax.oss.driver.internal.core.metadata.token.Murmur3Token;
import com.datastax.oss.driver.internal.core.metadata.token.Murmur3TokenFactory;
import com.datastax.oss.driver.internal.core.metadata.token.TokenRangeBase;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public class Murmur3TokenRange
extends TokenRangeBase {
    private static final BigInteger RING_END = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger RING_LENGTH = RING_END.subtract(BigInteger.valueOf(Long.MIN_VALUE));

    public Murmur3TokenRange(Murmur3Token start, Murmur3Token end) {
        super(start, end, Murmur3TokenFactory.MIN_TOKEN);
    }

    @Override
    protected TokenRange newTokenRange(Token start, Token end) {
        return new Murmur3TokenRange((Murmur3Token)start, (Murmur3Token)end);
    }

    @Override
    protected List<Token> split(Token startToken, Token endToken, int numberOfSplits) {
        if (startToken.equals(endToken) && startToken.equals(Murmur3TokenFactory.MIN_TOKEN)) {
            endToken = Murmur3TokenFactory.MAX_TOKEN;
        }
        BigInteger start = BigInteger.valueOf(((Murmur3Token)startToken).getValue());
        BigInteger end = BigInteger.valueOf(((Murmur3Token)endToken).getValue());
        BigInteger range2 = end.subtract(start);
        if (range2.compareTo(BigInteger.ZERO) < 0) {
            range2 = range2.add(RING_LENGTH);
        }
        List<BigInteger> values2 = super.split(start, range2, RING_END, RING_LENGTH, numberOfSplits);
        ArrayList<Token> tokens = Lists.newArrayListWithExpectedSize(values2.size());
        for (BigInteger value2 : values2) {
            tokens.add(new Murmur3Token(value2.longValue()));
        }
        return tokens;
    }
}

