/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.metadata.token.TokenRange;
import com.datastax.oss.driver.internal.core.metadata.token.Murmur3Token;
import com.datastax.oss.driver.internal.core.metadata.token.Murmur3TokenRange;
import com.datastax.oss.driver.internal.core.metadata.token.TokenFactory;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class Murmur3TokenFactory
implements TokenFactory {
    public static final String PARTITIONER_NAME = "org.apache.cassandra.dht.Murmur3Partitioner";
    public static final Murmur3Token MIN_TOKEN = new Murmur3Token(Long.MIN_VALUE);
    public static final Murmur3Token MAX_TOKEN = new Murmur3Token(Long.MAX_VALUE);

    @Override
    public String getPartitionerName() {
        return PARTITIONER_NAME;
    }

    @Override
    public Token hash(ByteBuffer partitionKey) {
        long v = this.murmur(partitionKey);
        return new Murmur3Token(v == Long.MIN_VALUE ? Long.MAX_VALUE : v);
    }

    @Override
    public Token parse(String tokenString) {
        return new Murmur3Token(Long.parseLong(tokenString));
    }

    @Override
    public String format(Token token2) {
        Preconditions.checkArgument(token2 instanceof Murmur3Token, "Can only format Murmur3Token instances");
        return Long.toString(((Murmur3Token)token2).getValue());
    }

    @Override
    public Token minToken() {
        return MIN_TOKEN;
    }

    @Override
    public TokenRange range(Token start, Token end) {
        Preconditions.checkArgument(start instanceof Murmur3Token && end instanceof Murmur3Token, "Can only build ranges of Murmur3Token instances");
        return new Murmur3TokenRange((Murmur3Token)start, (Murmur3Token)end);
    }

    private long murmur(ByteBuffer data2) {
        int offset = data2.position();
        int length = data2.remaining();
        int nblocks = length >> 4;
        long h1 = 0L;
        long h2 = 0L;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        for (int i = 0; i < nblocks; ++i) {
            long k1 = this.getblock(data2, offset, i * 2);
            long k2 = this.getblock(data2, offset, i * 2 + 1);
            k1 *= c1;
            k1 = this.rotl64(k1, 31);
            h1 ^= (k1 *= c2);
            h1 = this.rotl64(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            k2 *= c2;
            k2 = this.rotl64(k2, 33);
            h2 ^= (k2 *= c1);
            h2 = this.rotl64(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        offset += nblocks * 16;
        long k1 = 0L;
        long k2 = 0L;
        switch (length & 0xF) {
            case 15: {
                k2 ^= (long)data2.get(offset + 14) << 48;
            }
            case 14: {
                k2 ^= (long)data2.get(offset + 13) << 40;
            }
            case 13: {
                k2 ^= (long)data2.get(offset + 12) << 32;
            }
            case 12: {
                k2 ^= (long)data2.get(offset + 11) << 24;
            }
            case 11: {
                k2 ^= (long)data2.get(offset + 10) << 16;
            }
            case 10: {
                k2 ^= (long)data2.get(offset + 9) << 8;
            }
            case 9: {
                k2 ^= (long)data2.get(offset + 8);
                k2 *= c2;
                k2 = this.rotl64(k2, 33);
                h2 ^= (k2 *= c1);
            }
            case 8: {
                k1 ^= (long)data2.get(offset + 7) << 56;
            }
            case 7: {
                k1 ^= (long)data2.get(offset + 6) << 48;
            }
            case 6: {
                k1 ^= (long)data2.get(offset + 5) << 40;
            }
            case 5: {
                k1 ^= (long)data2.get(offset + 4) << 32;
            }
            case 4: {
                k1 ^= (long)data2.get(offset + 3) << 24;
            }
            case 3: {
                k1 ^= (long)data2.get(offset + 2) << 16;
            }
            case 2: {
                k1 ^= (long)data2.get(offset + 1) << 8;
            }
            case 1: {
                k1 ^= (long)data2.get(offset);
                k1 *= c1;
                k1 = this.rotl64(k1, 31);
                h1 ^= (k1 *= c2);
            }
        }
        h1 ^= (long)length;
        h1 += (h2 ^= (long)length);
        h2 += h1;
        h1 = this.fmix(h1);
        h2 = this.fmix(h2);
        return h1 += h2;
    }

    private long getblock(ByteBuffer key, int offset, int index2) {
        int i_8 = index2 << 3;
        int blockOffset = offset + i_8;
        return ((long)key.get(blockOffset) & 0xFFL) + (((long)key.get(blockOffset + 1) & 0xFFL) << 8) + (((long)key.get(blockOffset + 2) & 0xFFL) << 16) + (((long)key.get(blockOffset + 3) & 0xFFL) << 24) + (((long)key.get(blockOffset + 4) & 0xFFL) << 32) + (((long)key.get(blockOffset + 5) & 0xFFL) << 40) + (((long)key.get(blockOffset + 6) & 0xFFL) << 48) + (((long)key.get(blockOffset + 7) & 0xFFL) << 56);
    }

    private long rotl64(long v, int n) {
        return v << n | v >>> 64 - n;
    }

    private long fmix(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }
}

