/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.refresh;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultMetadata;
import com.datastax.oss.driver.internal.core.metadata.MetadataRefresh;
import com.datastax.oss.driver.internal.core.metadata.schema.events.AggregateChangeEvent;
import com.datastax.oss.driver.internal.core.metadata.schema.events.FunctionChangeEvent;
import com.datastax.oss.driver.internal.core.metadata.schema.events.KeyspaceChangeEvent;
import com.datastax.oss.driver.internal.core.metadata.schema.events.TableChangeEvent;
import com.datastax.oss.driver.internal.core.metadata.schema.events.TypeChangeEvent;
import com.datastax.oss.driver.internal.core.metadata.schema.events.ViewChangeEvent;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class SchemaRefresh
implements MetadataRefresh {
    @VisibleForTesting
    public final Map<CqlIdentifier, KeyspaceMetadata> newKeyspaces;

    public SchemaRefresh(Map<CqlIdentifier, KeyspaceMetadata> newKeyspaces) {
        this.newKeyspaces = newKeyspaces;
    }

    @Override
    public MetadataRefresh.Result compute(DefaultMetadata oldMetadata, boolean tokenMapEnabled, InternalDriverContext context) {
        ImmutableList.Builder<Object> events2 = ImmutableList.builder();
        Map<CqlIdentifier, KeyspaceMetadata> oldKeyspaces = oldMetadata.getKeyspaces();
        for (CqlIdentifier removedKey : Sets.difference(oldKeyspaces.keySet(), this.newKeyspaces.keySet())) {
            events2.add((Object)KeyspaceChangeEvent.dropped(oldKeyspaces.get(removedKey)));
        }
        for (Map.Entry<CqlIdentifier, KeyspaceMetadata> entry2 : this.newKeyspaces.entrySet()) {
            CqlIdentifier key = entry2.getKey();
            this.computeEvents(oldKeyspaces.get(key), entry2.getValue(), events2);
        }
        return new MetadataRefresh.Result(oldMetadata.withSchema(this.newKeyspaces, tokenMapEnabled, context), (List<Object>)((Object)events2.build()));
    }

    private void computeEvents(KeyspaceMetadata oldKeyspace, KeyspaceMetadata newKeyspace, ImmutableList.Builder<Object> events2) {
        if (oldKeyspace == null) {
            events2.add((Object)KeyspaceChangeEvent.created(newKeyspace));
        } else {
            if (!oldKeyspace.shallowEquals(newKeyspace)) {
                events2.add((Object)KeyspaceChangeEvent.updated(oldKeyspace, newKeyspace));
            }
            this.computeChildEvents(oldKeyspace, newKeyspace, events2);
        }
    }

    private void computeChildEvents(KeyspaceMetadata oldKeyspace, KeyspaceMetadata newKeyspace, ImmutableList.Builder<Object> events2) {
        this.computeChildEvents(oldKeyspace.getTables(), newKeyspace.getTables(), TableChangeEvent::dropped, TableChangeEvent::created, TableChangeEvent::updated, events2);
        this.computeChildEvents(oldKeyspace.getViews(), newKeyspace.getViews(), ViewChangeEvent::dropped, ViewChangeEvent::created, ViewChangeEvent::updated, events2);
        this.computeChildEvents(oldKeyspace.getUserDefinedTypes(), newKeyspace.getUserDefinedTypes(), TypeChangeEvent::dropped, TypeChangeEvent::created, TypeChangeEvent::updated, events2);
        this.computeChildEvents(oldKeyspace.getFunctions(), newKeyspace.getFunctions(), FunctionChangeEvent::dropped, FunctionChangeEvent::created, FunctionChangeEvent::updated, events2);
        this.computeChildEvents(oldKeyspace.getAggregates(), newKeyspace.getAggregates(), AggregateChangeEvent::dropped, AggregateChangeEvent::created, AggregateChangeEvent::updated, events2);
    }

    private <K, V> void computeChildEvents(Map<K, V> oldChildren, Map<K, V> newChildren, Function<V, Object> newDroppedEvent, Function<V, Object> newCreatedEvent, BiFunction<V, V, Object> newUpdatedEvent, ImmutableList.Builder<Object> events2) {
        for (Object removedKey : Sets.difference(oldChildren.keySet(), newChildren.keySet())) {
            events2.add(newDroppedEvent.apply(oldChildren.get(removedKey)));
        }
        for (Map.Entry<K, V> entry2 : newChildren.entrySet()) {
            K key = entry2.getKey();
            V newChild = entry2.getValue();
            V oldChild = oldChildren.get(key);
            if (oldChild == null) {
                events2.add(newCreatedEvent.apply(newChild));
                continue;
            }
            if (oldChild.equals(newChild)) continue;
            events2.add(newUpdatedEvent.apply(oldChild, newChild));
        }
    }
}

