/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.parsing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class SimpleJsonParser {
    private final String input;
    private int idx;

    private SimpleJsonParser(String input2) {
        this.input = input2;
    }

    public static List<String> parseStringList(String input2) {
        if (input2 == null || input2.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> output = new ArrayList<String>();
        SimpleJsonParser parser2 = new SimpleJsonParser(input2);
        if (parser2.nextCharSkipSpaces() != '[') {
            throw new IllegalArgumentException("Not a JSON list: " + input2);
        }
        char c = parser2.nextCharSkipSpaces();
        if (c == ']') {
            return output;
        }
        while (true) {
            assert (c == '\"');
            output.add(parser2.nextString());
            c = parser2.nextCharSkipSpaces();
            if (c == ']') {
                return output;
            }
            assert (c == ',');
            c = parser2.nextCharSkipSpaces();
        }
    }

    public static Map<String, String> parseStringMap(String input2) {
        if (input2 == null || input2.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> output = new HashMap<String, String>();
        SimpleJsonParser parser2 = new SimpleJsonParser(input2);
        if (parser2.nextCharSkipSpaces() != '{') {
            throw new IllegalArgumentException("Not a JSON map: " + input2);
        }
        char c = parser2.nextCharSkipSpaces();
        if (c == '}') {
            return output;
        }
        while (true) {
            assert (c == '\"');
            String key = parser2.nextString();
            c = parser2.nextCharSkipSpaces();
            assert (c == ':');
            c = parser2.nextCharSkipSpaces();
            assert (c == '\"');
            String value2 = parser2.nextString();
            output.put(key, value2);
            c = parser2.nextCharSkipSpaces();
            if (c == '}') {
                return output;
            }
            assert (c == ',');
            c = parser2.nextCharSkipSpaces();
        }
    }

    private char nextChar() {
        if (this.idx >= this.input.length()) {
            throw new IllegalArgumentException("Invalid json input: " + this.input);
        }
        return this.input.charAt(this.idx++);
    }

    private char nextCharSkipSpaces() {
        char c = this.nextChar();
        while (c == ' ' || c == '\t' || c == '\n') {
            c = this.nextChar();
        }
        return c;
    }

    private String nextString() {
        assert (this.input.charAt(this.idx - 1) == '\"') : "Char is '" + this.input.charAt(this.idx - 1) + '\'';
        StringBuilder sb = new StringBuilder();
        block13: while (true) {
            char c = this.nextChar();
            switch (c) {
                case '\n': 
                case '\r': {
                    throw new IllegalArgumentException("Unterminated string");
                }
                case '\\': {
                    c = this.nextChar();
                    switch (c) {
                        case 'b': {
                            sb.append('\b');
                            continue block13;
                        }
                        case 't': {
                            sb.append('\t');
                            continue block13;
                        }
                        case 'n': {
                            sb.append('\n');
                            continue block13;
                        }
                        case 'f': {
                            sb.append('\f');
                            continue block13;
                        }
                        case 'r': {
                            sb.append('\r');
                            continue block13;
                        }
                        case 'u': {
                            sb.append((char)Integer.parseInt(this.input.substring(this.idx, this.idx + 4), 16));
                            this.idx += 4;
                            continue block13;
                        }
                        case '\"': 
                        case '\'': 
                        case '/': 
                        case '\\': {
                            sb.append(c);
                            continue block13;
                        }
                    }
                    throw new IllegalArgumentException("Illegal escape");
                }
            }
            if (c == '\"') {
                return sb.toString();
            }
            sb.append(c);
        }
    }
}

