/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.parsing;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.schema.ShallowUserDefinedType;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeParser;
import com.datastax.oss.driver.internal.core.type.DefaultTupleType;
import com.datastax.oss.driver.internal.core.type.codec.ParseUtils;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DataTypeCqlNameParser
implements DataTypeParser {
    @VisibleForTesting
    static final ImmutableMap<String, DataType> NATIVE_TYPES_BY_NAME = new ImmutableMap.Builder<String, DataType>().put("ascii", DataTypes.ASCII).put("bigint", DataTypes.BIGINT).put("blob", DataTypes.BLOB).put("boolean", DataTypes.BOOLEAN).put("counter", DataTypes.COUNTER).put("decimal", DataTypes.DECIMAL).put("double", DataTypes.DOUBLE).put("float", DataTypes.FLOAT).put("inet", DataTypes.INET).put("int", DataTypes.INT).put("text", DataTypes.TEXT).put("varchar", DataTypes.TEXT).put("timestamp", DataTypes.TIMESTAMP).put("date", DataTypes.DATE).put("time", DataTypes.TIME).put("uuid", DataTypes.UUID).put("varint", DataTypes.VARINT).put("timeuuid", DataTypes.TIMEUUID).put("tinyint", DataTypes.TINYINT).put("smallint", DataTypes.SMALLINT).put("duration", DataTypes.DURATION).build();

    @Override
    public DataType parse(CqlIdentifier keyspaceId, String toParse, Map<CqlIdentifier, UserDefinedType> userTypes, InternalDriverContext context) {
        return this.parse(toParse, keyspaceId, false, userTypes, context);
    }

    private DataType parse(String toParse, CqlIdentifier keyspaceId, boolean frozen, Map<CqlIdentifier, UserDefinedType> userTypes, InternalDriverContext context) {
        if (toParse.startsWith("'")) {
            return DataTypes.custom(toParse.substring(1, toParse.length() - 1));
        }
        Parser parser2 = new Parser(toParse, 0);
        String type = parser2.parseTypeName();
        if (type.equalsIgnoreCase("empty")) {
            return DataTypes.custom(type);
        }
        DataType nativeType = NATIVE_TYPES_BY_NAME.get(type.toLowerCase());
        if (nativeType != null) {
            return nativeType;
        }
        if (parser2.isEOS()) {
            CqlIdentifier name2 = CqlIdentifier.fromCql(type);
            if (userTypes != null) {
                UserDefinedType userType = userTypes.get(name2);
                if (userType == null) {
                    throw new IllegalStateException(String.format("Can't find referenced user type %s", type));
                }
                return userType.copy(frozen);
            }
            return new ShallowUserDefinedType(keyspaceId, name2, frozen);
        }
        List<String> parameters = parser2.parseTypeParameters();
        if (type.equalsIgnoreCase("list")) {
            if (parameters.size() != 1) {
                throw new IllegalArgumentException(String.format("Expecting single parameter for list, got %s", parameters));
            }
            DataType elementType2 = this.parse(parameters.get(0), keyspaceId, false, userTypes, context);
            return DataTypes.listOf(elementType2, frozen);
        }
        if (type.equalsIgnoreCase("set")) {
            if (parameters.size() != 1) {
                throw new IllegalArgumentException(String.format("Expecting single parameter for set, got %s", parameters));
            }
            DataType elementType3 = this.parse(parameters.get(0), keyspaceId, false, userTypes, context);
            return DataTypes.setOf(elementType3, frozen);
        }
        if (type.equalsIgnoreCase("map")) {
            if (parameters.size() != 2) {
                throw new IllegalArgumentException(String.format("Expecting two parameters for map, got %s", parameters));
            }
            DataType keyType = this.parse(parameters.get(0), keyspaceId, false, userTypes, context);
            DataType valueType = this.parse(parameters.get(1), keyspaceId, false, userTypes, context);
            return DataTypes.mapOf(keyType, valueType, frozen);
        }
        if (type.equalsIgnoreCase("frozen")) {
            if (parameters.size() != 1) {
                throw new IllegalArgumentException(String.format("Expecting single parameter for frozen keyword, got %s", parameters));
            }
            return this.parse(parameters.get(0), keyspaceId, true, userTypes, context);
        }
        if (type.equalsIgnoreCase("tuple")) {
            if (parameters.isEmpty()) {
                throw new IllegalArgumentException("Expecting at list one parameter for tuple, got none");
            }
            ImmutableList.Builder componentTypesBuilder = ImmutableList.builder();
            for (String rawType : parameters) {
                componentTypesBuilder.add(this.parse(rawType, keyspaceId, false, userTypes, context));
            }
            return new DefaultTupleType((List<DataType>)((Object)componentTypesBuilder.build()), context);
        }
        throw new IllegalArgumentException("Could not parse type name " + toParse);
    }

    private static class Parser {
        private final String str;
        private int idx;

        Parser(String str, int idx) {
            this.str = str;
            this.idx = idx;
        }

        String parseTypeName() {
            this.idx = ParseUtils.skipSpaces(this.str, this.idx);
            return this.readNextIdentifier();
        }

        List<String> parseTypeParameters() {
            ArrayList<String> list2 = new ArrayList<String>();
            if (this.isEOS()) {
                return list2;
            }
            this.skipBlankAndComma();
            if (this.str.charAt(this.idx) != '<') {
                throw new IllegalStateException();
            }
            ++this.idx;
            while (this.skipBlankAndComma()) {
                if (this.str.charAt(this.idx) == '>') {
                    ++this.idx;
                    return list2;
                }
                String name2 = this.parseTypeName();
                String args2 = this.readRawTypeParameters();
                list2.add(name2 + args2);
            }
            throw new IllegalArgumentException(String.format("Syntax error parsing '%s' at char %d: unexpected end of string", this.str, this.idx));
        }

        private String readNextIdentifier() {
            int startIdx;
            if (this.str.charAt(startIdx = this.idx++) == '\"') {
                while (!this.isEOS()) {
                    boolean atQuote = this.str.charAt(this.idx) == '\"';
                    ++this.idx;
                    if (!atQuote) continue;
                    if (!this.isEOS() && this.str.charAt(this.idx) == '\"') {
                        ++this.idx;
                        continue;
                    }
                    break;
                }
            } else if (this.str.charAt(startIdx) == '\'') {
                ++this.idx;
                while (!this.isEOS() && this.str.charAt(this.idx++) != '\'') {
                }
            } else {
                while (!this.isEOS() && (ParseUtils.isCqlIdentifierChar(this.str.charAt(this.idx)) || this.str.charAt(this.idx) == '\"')) {
                    ++this.idx;
                }
            }
            return this.str.substring(startIdx, this.idx);
        }

        private String readRawTypeParameters() {
            this.idx = ParseUtils.skipSpaces(this.str, this.idx);
            if (this.isEOS() || this.str.charAt(this.idx) == '>' || this.str.charAt(this.idx) == ',') {
                return "";
            }
            if (this.str.charAt(this.idx) != '<') {
                throw new IllegalStateException(String.format("Expecting char %d of %s to be '<' but '%c' found", this.idx, this.str, Character.valueOf(this.str.charAt(this.idx))));
            }
            int i = this.idx;
            int open2 = 1;
            boolean inQuotes = false;
            while (open2 > 0) {
                ++this.idx;
                if (this.isEOS()) {
                    throw new IllegalStateException("Non closed angle brackets");
                }
                if (!inQuotes) {
                    if (this.str.charAt(this.idx) == '\"') {
                        inQuotes = true;
                        continue;
                    }
                    if (this.str.charAt(this.idx) == '<') {
                        ++open2;
                        continue;
                    }
                    if (this.str.charAt(this.idx) != '>') continue;
                    --open2;
                    continue;
                }
                if (this.str.charAt(this.idx) != '\"') continue;
                inQuotes = false;
            }
            ++this.idx;
            return this.str.substring(i, this.idx);
        }

        private boolean skipBlankAndComma() {
            boolean commaFound = false;
            while (!this.isEOS()) {
                char c = this.str.charAt(this.idx);
                if (c == ',') {
                    if (commaFound) {
                        return true;
                    }
                    commaFound = true;
                } else if (!ParseUtils.isBlank(c)) {
                    return true;
                }
                ++this.idx;
            }
            return false;
        }

        private boolean isEOS() {
            return this.idx >= this.str.length();
        }

        public String toString() {
            return this.str.substring(0, this.idx) + "[" + (this.idx == this.str.length() ? "" : Character.valueOf(this.str.charAt(this.idx))) + "]" + this.str.substring(this.idx + 1);
        }
    }
}

