/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.parsing;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeParser;
import com.datastax.oss.driver.internal.core.type.DefaultTupleType;
import com.datastax.oss.driver.internal.core.type.UserDefinedTypeBuilder;
import com.datastax.oss.driver.internal.core.type.codec.ParseUtils;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DataTypeClassNameParser
implements DataTypeParser {
    private static final Logger LOG = LoggerFactory.getLogger(DataTypeClassNameParser.class);
    @VisibleForTesting
    static ImmutableMap<String, DataType> NATIVE_TYPES_BY_CLASS_NAME = new ImmutableMap.Builder<String, DataType>().put("org.apache.cassandra.db.marshal.AsciiType", DataTypes.ASCII).put("org.apache.cassandra.db.marshal.LongType", DataTypes.BIGINT).put("org.apache.cassandra.db.marshal.BytesType", DataTypes.BLOB).put("org.apache.cassandra.db.marshal.BooleanType", DataTypes.BOOLEAN).put("org.apache.cassandra.db.marshal.CounterColumnType", DataTypes.COUNTER).put("org.apache.cassandra.db.marshal.DecimalType", DataTypes.DECIMAL).put("org.apache.cassandra.db.marshal.DoubleType", DataTypes.DOUBLE).put("org.apache.cassandra.db.marshal.FloatType", DataTypes.FLOAT).put("org.apache.cassandra.db.marshal.InetAddressType", DataTypes.INET).put("org.apache.cassandra.db.marshal.Int32Type", DataTypes.INT).put("org.apache.cassandra.db.marshal.UTF8Type", DataTypes.TEXT).put("org.apache.cassandra.db.marshal.TimestampType", DataTypes.TIMESTAMP).put("org.apache.cassandra.db.marshal.SimpleDateType", DataTypes.DATE).put("org.apache.cassandra.db.marshal.TimeType", DataTypes.TIME).put("org.apache.cassandra.db.marshal.UUIDType", DataTypes.UUID).put("org.apache.cassandra.db.marshal.IntegerType", DataTypes.VARINT).put("org.apache.cassandra.db.marshal.TimeUUIDType", DataTypes.TIMEUUID).put("org.apache.cassandra.db.marshal.ByteType", DataTypes.TINYINT).put("org.apache.cassandra.db.marshal.ShortType", DataTypes.SMALLINT).put("org.apache.cassandra.db.marshal.DurationType", DataTypes.DURATION).build();

    @Override
    public DataType parse(CqlIdentifier keyspaceId, String toParse, Map<CqlIdentifier, UserDefinedType> userTypes, InternalDriverContext context) {
        return this.parse(toParse, userTypes, context, context.getSessionName());
    }

    public DataType parse(String toParse, AttachmentPoint attachmentPoint) {
        return this.parse(toParse, null, attachmentPoint, "parser");
    }

    private DataType parse(String toParse, Map<CqlIdentifier, UserDefinedType> userTypes, AttachmentPoint attachmentPoint, String logPrefix) {
        boolean frozen = false;
        if (DataTypeClassNameParser.isReversed(toParse)) {
            toParse = DataTypeClassNameParser.getNestedClassName(toParse);
        } else if (toParse.startsWith("org.apache.cassandra.db.marshal.FrozenType")) {
            frozen = true;
            toParse = DataTypeClassNameParser.getNestedClassName(toParse);
        }
        Parser parser2 = new Parser(toParse, 0);
        String next2 = parser2.parseNextName();
        if (next2.startsWith("org.apache.cassandra.db.marshal.ListType")) {
            DataType elementType2 = this.parse(parser2.getTypeParameters().get(0), userTypes, attachmentPoint, logPrefix);
            return DataTypes.listOf(elementType2, frozen);
        }
        if (next2.startsWith("org.apache.cassandra.db.marshal.SetType")) {
            DataType elementType3 = this.parse(parser2.getTypeParameters().get(0), userTypes, attachmentPoint, logPrefix);
            return DataTypes.setOf(elementType3, frozen);
        }
        if (next2.startsWith("org.apache.cassandra.db.marshal.MapType")) {
            List<String> parameters = parser2.getTypeParameters();
            DataType keyType = this.parse(parameters.get(0), userTypes, attachmentPoint, logPrefix);
            DataType valueType = this.parse(parameters.get(1), userTypes, attachmentPoint, logPrefix);
            return DataTypes.mapOf(keyType, valueType, frozen);
        }
        if (frozen) {
            LOG.warn("[{}] Got o.a.c.db.marshal.FrozenType for something else than a collection, this driver version might be too old for your version of Cassandra", (Object)logPrefix);
        }
        if (next2.startsWith("org.apache.cassandra.db.marshal.UserType")) {
            ++parser2.idx;
            CqlIdentifier keyspace = CqlIdentifier.fromInternal(parser2.readOne());
            parser2.skipBlankAndComma();
            String typeName = TypeCodecs.TEXT.decode(Bytes.fromHexString("0x" + parser2.readOne()), attachmentPoint.getProtocolVersion());
            if (typeName == null) {
                throw new AssertionError((Object)"Type name cannot be null, this is a server bug");
            }
            CqlIdentifier typeId = CqlIdentifier.fromInternal(typeName);
            Map nameAndTypeParameters = parser2.getNameAndTypeParameters();
            if (userTypes != null && userTypes.containsKey(typeId)) {
                return userTypes.get(typeId).copy(true);
            }
            UserDefinedTypeBuilder builder = new UserDefinedTypeBuilder(keyspace, typeId);
            parser2.skipBlankAndComma();
            for (Map.Entry entry2 : nameAndTypeParameters.entrySet()) {
                CqlIdentifier fieldName = CqlIdentifier.fromInternal((String)entry2.getKey());
                DataType fieldType = this.parse((String)entry2.getValue(), userTypes, attachmentPoint, logPrefix);
                builder.withField(fieldName, fieldType);
            }
            return builder.frozen().withAttachmentPoint(attachmentPoint).build();
        }
        if (next2.startsWith("org.apache.cassandra.db.marshal.TupleType")) {
            List<String> rawTypes = parser2.getTypeParameters();
            ImmutableList.Builder componentTypesBuilder = ImmutableList.builder();
            for (String rawType : rawTypes) {
                componentTypesBuilder.add(this.parse(rawType, userTypes, attachmentPoint, logPrefix));
            }
            return new DefaultTupleType((List<DataType>)((Object)componentTypesBuilder.build()), attachmentPoint);
        }
        DataType type = NATIVE_TYPES_BY_CLASS_NAME.get(next2);
        return type == null ? DataTypes.custom(toParse) : type;
    }

    static boolean isReversed(String toParse) {
        return toParse.startsWith("org.apache.cassandra.db.marshal.ReversedType");
    }

    private static String getNestedClassName(String className2) {
        Parser p = new Parser(className2, 0);
        p.parseNextName();
        List<String> l = p.getTypeParameters();
        if (l.size() != 1) {
            throw new IllegalStateException();
        }
        className2 = l.get(0);
        return className2;
    }

    static class Parser {
        private final String str;
        private int idx;

        Parser(String str, int idx) {
            this.str = str;
            this.idx = idx;
        }

        String parseNextName() {
            this.skipBlank();
            return this.readNextIdentifier();
        }

        private String readOne() {
            String name2 = this.parseNextName();
            String args2 = this.readRawArguments();
            return name2 + args2;
        }

        private String readRawArguments() {
            this.skipBlank();
            if (this.isEOS() || this.str.charAt(this.idx) == ')' || this.str.charAt(this.idx) == ',') {
                return "";
            }
            if (this.str.charAt(this.idx) != '(') {
                throw new IllegalStateException(String.format("Expecting char %d of %s to be '(' but '%c' found", this.idx, this.str, Character.valueOf(this.str.charAt(this.idx))));
            }
            int i = this.idx;
            int open2 = 1;
            while (open2 > 0) {
                ++this.idx;
                if (this.isEOS()) {
                    throw new IllegalStateException("Non closed parenthesis");
                }
                if (this.str.charAt(this.idx) == '(') {
                    ++open2;
                    continue;
                }
                if (this.str.charAt(this.idx) != ')') continue;
                --open2;
            }
            ++this.idx;
            return this.str.substring(i, this.idx);
        }

        List<String> getTypeParameters() {
            ArrayList<String> list2 = new ArrayList<String>();
            if (this.isEOS()) {
                return list2;
            }
            if (this.str.charAt(this.idx) != '(') {
                throw new IllegalStateException();
            }
            ++this.idx;
            while (this.skipBlankAndComma()) {
                if (this.str.charAt(this.idx) == ')') {
                    ++this.idx;
                    return list2;
                }
                list2.add(this.readOne());
            }
            throw new IllegalArgumentException(String.format("Syntax error parsing '%s' at char %d: unexpected end of string", this.str, this.idx));
        }

        Map<String, String> getCollectionsParameters() {
            if (this.isEOS()) {
                return Collections.emptyMap();
            }
            if (this.str.charAt(this.idx) != '(') {
                throw new IllegalStateException();
            }
            ++this.idx;
            return this.getNameAndTypeParameters();
        }

        private Map<String, String> getNameAndTypeParameters() {
            LinkedHashMap<String, String> map2 = new LinkedHashMap<String, String>();
            while (this.skipBlankAndComma()) {
                if (this.str.charAt(this.idx) == ')') {
                    ++this.idx;
                    return map2;
                }
                String bbHex = this.readNextIdentifier();
                String name2 = null;
                try {
                    name2 = TypeCodecs.TEXT.decode(Bytes.fromHexString("0x" + bbHex), DefaultProtocolVersion.DEFAULT);
                }
                catch (NumberFormatException e) {
                    this.throwSyntaxError(e.getMessage());
                }
                this.skipBlank();
                if (this.str.charAt(this.idx) != ':') {
                    this.throwSyntaxError("expecting ':' token");
                }
                ++this.idx;
                this.skipBlank();
                map2.put(name2, this.readOne());
            }
            throw new IllegalArgumentException(String.format("Syntax error parsing '%s' at char %d: unexpected end of string", this.str, this.idx));
        }

        private void throwSyntaxError(String msg) {
            throw new IllegalArgumentException(String.format("Syntax error parsing '%s' at char %d: %s", this.str, this.idx, msg));
        }

        private boolean isEOS() {
            return Parser.isEOS(this.str, this.idx);
        }

        private static boolean isEOS(String str, int i) {
            return i >= str.length();
        }

        private void skipBlank() {
            this.idx = Parser.skipBlank(this.str, this.idx);
        }

        private static int skipBlank(String str, int i) {
            while (!Parser.isEOS(str, i) && ParseUtils.isBlank(str.charAt(i))) {
                ++i;
            }
            return i;
        }

        private boolean skipBlankAndComma() {
            boolean commaFound = false;
            while (!this.isEOS()) {
                char c = this.str.charAt(this.idx);
                if (c == ',') {
                    if (commaFound) {
                        return true;
                    }
                    commaFound = true;
                } else if (!ParseUtils.isBlank(c)) {
                    return true;
                }
                ++this.idx;
            }
            return false;
        }

        private String readNextIdentifier() {
            int i = this.idx;
            while (!this.isEOS() && ParseUtils.isCqlIdentifierChar(this.str.charAt(this.idx))) {
                ++this.idx;
            }
            return this.str.substring(i, this.idx);
        }

        public String toString() {
            return this.str.substring(0, this.idx) + "[" + (this.idx == this.str.length() ? "" : Character.valueOf(this.str.charAt(this.idx))) + "]" + this.str.substring(this.idx + 1);
        }
    }
}

