/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.parsing;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeClassNameParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DataTypeClassNameCompositeParser
extends DataTypeClassNameParser {
    public ParseResult parseWithComposite(String className2, CqlIdentifier keyspaceId, Map<CqlIdentifier, UserDefinedType> userTypes, InternalDriverContext context) {
        DataTypeClassNameParser.Parser parser2 = new DataTypeClassNameParser.Parser(className2, 0);
        String next2 = parser2.parseNextName();
        if (!DataTypeClassNameCompositeParser.isComposite(next2)) {
            return new ParseResult(this.parse(keyspaceId, className2, userTypes, context), DataTypeClassNameCompositeParser.isReversed(next2));
        }
        List<String> subClassNames = parser2.getTypeParameters();
        int count2 = subClassNames.size();
        String last2 = subClassNames.get(count2 - 1);
        HashMap<String, DataType> collections = new HashMap<String, DataType>();
        if (DataTypeClassNameCompositeParser.isCollection(last2)) {
            --count2;
            DataTypeClassNameParser.Parser collectionParser = new DataTypeClassNameParser.Parser(last2, 0);
            collectionParser.parseNextName();
            Map<String, String> params2 = collectionParser.getCollectionsParameters();
            for (Map.Entry<String, String> entry2 : params2.entrySet()) {
                collections.put(entry2.getKey(), this.parse(keyspaceId, entry2.getValue(), userTypes, context));
            }
        }
        ArrayList<DataType> types2 = new ArrayList<DataType>(count2);
        ArrayList<Boolean> reversed2 = new ArrayList<Boolean>(count2);
        for (int i = 0; i < count2; ++i) {
            types2.add(this.parse(keyspaceId, subClassNames.get(i), userTypes, context));
            reversed2.add(DataTypeClassNameCompositeParser.isReversed(subClassNames.get(i)));
        }
        return new ParseResult(true, types2, reversed2, collections);
    }

    private static boolean isComposite(String className2) {
        return className2.startsWith("org.apache.cassandra.db.marshal.CompositeType");
    }

    private static boolean isCollection(String className2) {
        return className2.startsWith("org.apache.cassandra.db.marshal.ColumnToCollectionType");
    }

    public static class ParseResult {
        public final boolean isComposite;
        public final List<DataType> types;
        public final List<Boolean> reversed;
        public final Map<String, DataType> collections;

        private ParseResult(DataType type, boolean reversed2) {
            this(false, Collections.singletonList(type), Collections.singletonList(reversed2), Collections.emptyMap());
        }

        private ParseResult(boolean isComposite, List<DataType> types2, List<Boolean> reversed2, Map<String, DataType> collections) {
            this.isComposite = isComposite;
            this.types = types2;
            this.reversed = reversed2;
            this.collections = collections;
        }
    }
}

