/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.parsing;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.AggregateMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionSignature;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.schema.DefaultAggregateMetadata;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeParser;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class AggregateParser {
    private final DataTypeParser dataTypeParser;
    private final InternalDriverContext context;

    public AggregateParser(DataTypeParser dataTypeParser, InternalDriverContext context) {
        this.dataTypeParser = dataTypeParser;
        this.context = context;
    }

    public AggregateMetadata parseAggregate(AdminRow row, CqlIdentifier keyspaceId, Map<CqlIdentifier, UserDefinedType> userDefinedTypes) {
        ByteBuffer initCondBlob;
        String initCondString;
        String simpleName = row.getString("aggregate_name");
        List<String> argumentTypes = row.getListOfString("argument_types");
        FunctionSignature signature2 = new FunctionSignature(CqlIdentifier.fromInternal(simpleName), this.dataTypeParser.parse(keyspaceId, argumentTypes, userDefinedTypes, this.context));
        DataType stateType = this.dataTypeParser.parse(keyspaceId, row.getString("state_type"), userDefinedTypes, this.context);
        TypeCodec<Object> stateTypeCodec = this.context.getCodecRegistry().codecFor(stateType);
        String stateFuncSimpleName = row.getString("state_func");
        FunctionSignature stateFuncSignature = new FunctionSignature(CqlIdentifier.fromInternal(stateFuncSimpleName), (Iterable<DataType>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(stateType)).addAll(signature2.getParameterTypes())).build());
        String finalFuncSimpleName = row.getString("final_func");
        FunctionSignature finalFuncSignature = finalFuncSimpleName == null ? null : new FunctionSignature(CqlIdentifier.fromInternal(finalFuncSimpleName), stateType);
        DataType returnType = this.dataTypeParser.parse(keyspaceId, row.getString("return_type"), userDefinedTypes, this.context);
        DataType initCond = row.isString("initcond") ? ((initCondString = row.getString("initcond")) == null ? null : stateTypeCodec.parse(initCondString)) : ((initCondBlob = row.getByteBuffer("initcond")) == null ? null : stateTypeCodec.decode(initCondBlob, this.context.getProtocolVersion()));
        return new DefaultAggregateMetadata(keyspaceId, signature2, finalFuncSignature, initCond, returnType, stateFuncSignature, stateType, stateTypeCodec);
    }
}

