/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.IndexMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultTableMetadata
implements TableMetadata,
Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final CqlIdentifier keyspace;
    @NonNull
    private final CqlIdentifier name;
    @Nullable
    private final UUID id;
    private final boolean compactStorage;
    private final boolean virtual;
    @NonNull
    private final List<ColumnMetadata> partitionKey;
    @NonNull
    private final Map<ColumnMetadata, ClusteringOrder> clusteringColumns;
    @NonNull
    private final Map<CqlIdentifier, ColumnMetadata> columns;
    @NonNull
    private final Map<CqlIdentifier, Object> options;
    @NonNull
    private final Map<CqlIdentifier, IndexMetadata> indexes;

    public DefaultTableMetadata(@NonNull CqlIdentifier keyspace, @NonNull CqlIdentifier name2, @Nullable UUID id, boolean compactStorage, boolean virtual, @NonNull List<ColumnMetadata> partitionKey, @NonNull Map<ColumnMetadata, ClusteringOrder> clusteringColumns, @NonNull Map<CqlIdentifier, ColumnMetadata> columns, @NonNull Map<CqlIdentifier, Object> options, @NonNull Map<CqlIdentifier, IndexMetadata> indexes) {
        this.keyspace = keyspace;
        this.name = name2;
        this.id = id;
        this.compactStorage = compactStorage;
        this.virtual = virtual;
        this.partitionKey = partitionKey;
        this.clusteringColumns = clusteringColumns;
        this.columns = columns;
        this.options = options;
        this.indexes = indexes;
    }

    @Override
    @NonNull
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @Override
    @NonNull
    public CqlIdentifier getName() {
        return this.name;
    }

    @Override
    @NonNull
    public Optional<UUID> getId() {
        return Optional.ofNullable(this.id);
    }

    @Override
    public boolean isCompactStorage() {
        return this.compactStorage;
    }

    @Override
    public boolean isVirtual() {
        return this.virtual;
    }

    @Override
    @NonNull
    public List<ColumnMetadata> getPartitionKey() {
        return this.partitionKey;
    }

    @Override
    @NonNull
    public Map<ColumnMetadata, ClusteringOrder> getClusteringColumns() {
        return this.clusteringColumns;
    }

    @Override
    @NonNull
    public Map<CqlIdentifier, ColumnMetadata> getColumns() {
        return this.columns;
    }

    @Override
    @NonNull
    public Map<CqlIdentifier, Object> getOptions() {
        return this.options;
    }

    @Override
    @NonNull
    public Map<CqlIdentifier, IndexMetadata> getIndexes() {
        return this.indexes;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TableMetadata) {
            TableMetadata that = (TableMetadata)other;
            return Objects.equals(this.keyspace, that.getKeyspace()) && Objects.equals(this.name, that.getName()) && Objects.equals(Optional.ofNullable(this.id), that.getId()) && this.compactStorage == that.isCompactStorage() && this.virtual == that.isVirtual() && Objects.equals(this.partitionKey, that.getPartitionKey()) && Objects.equals(this.clusteringColumns, that.getClusteringColumns()) && Objects.equals(this.columns, that.getColumns()) && Objects.equals(this.indexes, that.getIndexes());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.keyspace, this.name, this.id, this.compactStorage, this.virtual, this.partitionKey, this.clusteringColumns, this.columns, this.indexes);
    }

    public String toString() {
        return "DefaultTableMetadata@" + Integer.toHexString(this.hashCode()) + "(" + this.keyspace.asInternal() + "." + this.name.asInternal() + ")";
    }
}

