/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionSignature;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultFunctionMetadata
implements FunctionMetadata,
Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final CqlIdentifier keyspace;
    @NonNull
    private final FunctionSignature signature;
    @NonNull
    private final List<CqlIdentifier> parameterNames;
    @NonNull
    private final String body;
    private final boolean calledOnNullInput;
    @NonNull
    private final String language;
    @NonNull
    private final DataType returnType;

    public DefaultFunctionMetadata(@NonNull CqlIdentifier keyspace, @NonNull FunctionSignature signature2, @NonNull List<CqlIdentifier> parameterNames, @NonNull String body2, boolean calledOnNullInput, @NonNull String language2, @NonNull DataType returnType) {
        Preconditions.checkArgument(signature2.getParameterTypes().size() == parameterNames.size(), "Number of parameter names should match number of types in the signature (got %s and %s)", parameterNames.size(), signature2.getParameterTypes().size());
        this.keyspace = keyspace;
        this.signature = signature2;
        this.parameterNames = parameterNames;
        this.body = body2;
        this.calledOnNullInput = calledOnNullInput;
        this.language = language2;
        this.returnType = returnType;
    }

    @Override
    @NonNull
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @Override
    @NonNull
    public FunctionSignature getSignature() {
        return this.signature;
    }

    @Override
    @NonNull
    public List<CqlIdentifier> getParameterNames() {
        return this.parameterNames;
    }

    @Override
    @NonNull
    public String getBody() {
        return this.body;
    }

    @Override
    public boolean isCalledOnNullInput() {
        return this.calledOnNullInput;
    }

    @Override
    @NonNull
    public String getLanguage() {
        return this.language;
    }

    @Override
    @NonNull
    public DataType getReturnType() {
        return this.returnType;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof FunctionMetadata) {
            FunctionMetadata that = (FunctionMetadata)other;
            return Objects.equals(this.keyspace, that.getKeyspace()) && Objects.equals(this.signature, that.getSignature()) && Objects.equals(this.parameterNames, that.getParameterNames()) && Objects.equals(this.body, that.getBody()) && this.calledOnNullInput == that.isCalledOnNullInput() && Objects.equals(this.language, that.getLanguage()) && Objects.equals(this.returnType, that.getReturnType());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.keyspace, this.signature, this.parameterNames, this.body, this.calledOnNullInput, this.language, this.returnType);
    }

    public String toString() {
        return "DefaultFunctionMetadata@" + Integer.toHexString(this.hashCode()) + "(" + this.keyspace.asInternal() + "." + this.signature + ")";
    }
}

