/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultColumnMetadata
implements ColumnMetadata,
Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final CqlIdentifier keyspace;
    @NonNull
    private final CqlIdentifier parent;
    @NonNull
    private final CqlIdentifier name;
    @NonNull
    private final DataType dataType;
    private final boolean isStatic;

    public DefaultColumnMetadata(@NonNull CqlIdentifier keyspace, @NonNull CqlIdentifier parent, @NonNull CqlIdentifier name2, @NonNull DataType dataType, boolean isStatic) {
        this.keyspace = keyspace;
        this.parent = parent;
        this.name = name2;
        this.dataType = dataType;
        this.isStatic = isStatic;
    }

    @Override
    @NonNull
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @Override
    @NonNull
    public CqlIdentifier getParent() {
        return this.parent;
    }

    @Override
    @NonNull
    public CqlIdentifier getName() {
        return this.name;
    }

    @Override
    @NonNull
    public DataType getType() {
        return this.dataType;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ColumnMetadata) {
            ColumnMetadata that = (ColumnMetadata)other;
            return Objects.equals(this.keyspace, that.getKeyspace()) && Objects.equals(this.parent, that.getParent()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.dataType, that.getType()) && this.isStatic == that.isStatic();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.keyspace, this.parent, this.name, this.dataType, this.isStatic);
    }

    public String toString() {
        return "DefaultColumnMetadata@" + Integer.toHexString(this.hashCode()) + "(" + this.keyspace.asInternal() + "." + this.parent.asInternal() + "." + this.name.asInternal() + " " + this.dataType.asCql(true, false) + ")";
    }
}

