/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.api.core.AsyncAutoCloseable;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeState;
import com.datastax.oss.driver.internal.core.channel.ChannelEvent;
import com.datastax.oss.driver.internal.core.context.EventBus;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.MetadataManager;
import com.datastax.oss.driver.internal.core.metadata.NodeStateEvent;
import com.datastax.oss.driver.internal.core.metadata.TopologyEvent;
import com.datastax.oss.driver.internal.core.util.Loggers;
import com.datastax.oss.driver.internal.core.util.concurrent.Debouncer;
import com.datastax.oss.driver.internal.core.util.concurrent.RunOrSchedule;
import com.datastax.oss.driver.shaded.guava.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.netty.util.concurrent.EventExecutor;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class NodeStateManager
implements AsyncAutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NodeStateManager.class);
    private final EventExecutor adminExecutor;
    private final SingleThreaded singleThreaded;
    private final String logPrefix;

    public NodeStateManager(InternalDriverContext context) {
        this.adminExecutor = context.getNettyOptions().adminEventExecutorGroup().next();
        this.singleThreaded = new SingleThreaded(context);
        this.logPrefix = context.getSessionName();
    }

    public void markInitialized() {
        RunOrSchedule.on(this.adminExecutor, () -> this.singleThreaded.markInitialized());
    }

    @Override
    @NonNull
    public CompletionStage<Void> closeFuture() {
        return this.singleThreaded.closeFuture;
    }

    @Override
    @NonNull
    public CompletionStage<Void> closeAsync() {
        RunOrSchedule.on(this.adminExecutor, () -> this.singleThreaded.close());
        return this.singleThreaded.closeFuture;
    }

    @Override
    @NonNull
    public CompletionStage<Void> forceCloseAsync() {
        return this.closeAsync();
    }

    private class SingleThreaded {
        private final MetadataManager metadataManager;
        private final EventBus eventBus;
        private final Debouncer<TopologyEvent, Collection<TopologyEvent>> topologyEventDebouncer;
        private final CompletableFuture<Void> closeFuture = new CompletableFuture();
        private boolean isInitialized = false;
        private boolean closeWasCalled;

        private SingleThreaded(InternalDriverContext context) {
            this.metadataManager = context.getMetadataManager();
            DriverExecutionProfile config = context.getConfig().getDefaultProfile();
            this.topologyEventDebouncer = new Debouncer(NodeStateManager.this.adminExecutor, this::coalesceTopologyEvents, this::flushTopologyEvents, config.getDuration(DefaultDriverOption.METADATA_TOPOLOGY_WINDOW), config.getInt(DefaultDriverOption.METADATA_TOPOLOGY_MAX_EVENTS));
            this.eventBus = context.getEventBus();
            this.eventBus.register(ChannelEvent.class, RunOrSchedule.on(NodeStateManager.this.adminExecutor, this::onChannelEvent));
            this.eventBus.register(TopologyEvent.class, RunOrSchedule.on(NodeStateManager.this.adminExecutor, this::onTopologyEvent));
        }

        private void markInitialized() {
            assert (NodeStateManager.this.adminExecutor.inEventLoop());
            this.isInitialized = true;
        }

        private void onChannelEvent(ChannelEvent event) {
            assert (NodeStateManager.this.adminExecutor.inEventLoop());
            if (this.closeWasCalled) {
                return;
            }
            LOG.debug("[{}] Processing {}", (Object)NodeStateManager.this.logPrefix, (Object)event);
            DefaultNode node = (DefaultNode)event.node;
            assert (node != null);
            switch (event.type) {
                case OPENED: {
                    ++node.openConnections;
                    if (node.state != NodeState.DOWN && node.state != NodeState.UNKNOWN) break;
                    this.setState(node, NodeState.UP, "a new connection was opened to it");
                    break;
                }
                case CLOSED: {
                    --node.openConnections;
                    if (node.openConnections != 0 || node.reconnections <= 0) break;
                    this.setState(node, NodeState.DOWN, "it was reconnecting and lost its last connection");
                    break;
                }
                case RECONNECTION_STARTED: {
                    ++node.reconnections;
                    if (node.openConnections != 0) break;
                    this.setState(node, NodeState.DOWN, "it has no connections and started reconnecting");
                    break;
                }
                case RECONNECTION_STOPPED: {
                    --node.reconnections;
                    break;
                }
                case CONTROL_CONNECTION_FAILED: {
                    if (this.isInitialized) break;
                    this.setState(node, NodeState.DOWN, "it was tried as a contact point but failed");
                }
            }
        }

        private void onDebouncedTopologyEvent(TopologyEvent event) {
            assert (NodeStateManager.this.adminExecutor.inEventLoop());
            if (this.closeWasCalled) {
                return;
            }
            LOG.debug("[{}] Processing {}", (Object)NodeStateManager.this.logPrefix, (Object)event);
            Optional<Node> maybeNode = this.metadataManager.getMetadata().findNode(event.broadcastRpcAddress);
            switch (event.type) {
                case SUGGEST_UP: {
                    if (maybeNode.isPresent()) {
                        DefaultNode node = (DefaultNode)maybeNode.get();
                        if (node.state == NodeState.FORCED_DOWN) {
                            LOG.debug("[{}] Not setting {} UP because it is FORCED_DOWN", (Object)NodeStateManager.this.logPrefix, (Object)node);
                            break;
                        }
                        if (node.distance != NodeDistance.IGNORED) break;
                        this.setState(node, NodeState.UP, "it is IGNORED and an UP topology event was received");
                        break;
                    }
                    LOG.debug("[{}] Received UP event for unknown node {}, adding it", (Object)NodeStateManager.this.logPrefix, (Object)event.broadcastRpcAddress);
                    this.metadataManager.addNode(event.broadcastRpcAddress);
                    break;
                }
                case SUGGEST_DOWN: {
                    if (maybeNode.isPresent()) {
                        DefaultNode node = (DefaultNode)maybeNode.get();
                        if (node.openConnections > 0) {
                            LOG.debug("[{}] Not setting {} DOWN because it still has active connections", (Object)NodeStateManager.this.logPrefix, (Object)node);
                            break;
                        }
                        if (node.state == NodeState.FORCED_DOWN) {
                            LOG.debug("[{}] Not setting {} DOWN because it is FORCED_DOWN", (Object)NodeStateManager.this.logPrefix, (Object)node);
                            break;
                        }
                        if (node.distance != NodeDistance.IGNORED) break;
                        this.setState(node, NodeState.DOWN, "it is IGNORED and a DOWN topology event was received");
                        break;
                    }
                    LOG.debug("[{}] Received DOWN event for unknown node {}, ignoring it", (Object)NodeStateManager.this.logPrefix, (Object)event.broadcastRpcAddress);
                    break;
                }
                case FORCE_UP: {
                    if (maybeNode.isPresent()) {
                        DefaultNode node = (DefaultNode)maybeNode.get();
                        this.setState(node, NodeState.UP, "a FORCE_UP topology event was received");
                        break;
                    }
                    LOG.debug("[{}] Received FORCE_UP event for unknown node {}, adding it", (Object)NodeStateManager.this.logPrefix, (Object)event.broadcastRpcAddress);
                    this.metadataManager.addNode(event.broadcastRpcAddress);
                    break;
                }
                case FORCE_DOWN: {
                    if (maybeNode.isPresent()) {
                        DefaultNode node = (DefaultNode)maybeNode.get();
                        this.setState(node, NodeState.FORCED_DOWN, "a FORCE_DOWN topology event was received");
                        break;
                    }
                    LOG.debug("[{}] Received FORCE_DOWN event for unknown node {}, ignoring it", (Object)NodeStateManager.this.logPrefix, (Object)event.broadcastRpcAddress);
                    break;
                }
                case SUGGEST_ADDED: {
                    if (maybeNode.isPresent()) {
                        DefaultNode node = (DefaultNode)maybeNode.get();
                        LOG.debug("[{}] Received ADDED event for {} but it is already in our metadata, ignoring", (Object)NodeStateManager.this.logPrefix, (Object)node);
                        break;
                    }
                    this.metadataManager.addNode(event.broadcastRpcAddress);
                    break;
                }
                case SUGGEST_REMOVED: {
                    if (maybeNode.isPresent()) {
                        this.metadataManager.removeNode(event.broadcastRpcAddress);
                        break;
                    }
                    LOG.debug("[{}] Received REMOVED event for {} but it is not in our metadata, ignoring", (Object)NodeStateManager.this.logPrefix, (Object)event.broadcastRpcAddress);
                }
            }
        }

        private void onTopologyEvent(TopologyEvent event) {
            assert (NodeStateManager.this.adminExecutor.inEventLoop());
            this.topologyEventDebouncer.receive(event);
        }

        private Collection<TopologyEvent> coalesceTopologyEvents(List<TopologyEvent> events2) {
            Collection<TopologyEvent> result2;
            assert (NodeStateManager.this.adminExecutor.inEventLoop());
            if (events2.size() == 1) {
                result2 = events2;
            } else {
                HashMap<InetSocketAddress, TopologyEvent> last2 = Maps.newHashMapWithExpectedSize(events2.size());
                for (TopologyEvent event : events2) {
                    if (!event.isForceEvent() && last2.containsKey(event.broadcastRpcAddress) && ((TopologyEvent)last2.get(event.broadcastRpcAddress)).isForceEvent()) continue;
                    last2.put(event.broadcastRpcAddress, event);
                }
                result2 = last2.values();
            }
            LOG.debug("[{}] Coalesced topology events: {} => {}", NodeStateManager.this.logPrefix, events2, result2);
            return result2;
        }

        private void flushTopologyEvents(Collection<TopologyEvent> events2) {
            assert (NodeStateManager.this.adminExecutor.inEventLoop());
            for (TopologyEvent event : events2) {
                this.onDebouncedTopologyEvent(event);
            }
        }

        private void close() {
            assert (NodeStateManager.this.adminExecutor.inEventLoop());
            if (this.closeWasCalled) {
                return;
            }
            this.closeWasCalled = true;
            this.topologyEventDebouncer.stop();
            this.closeFuture.complete(null);
        }

        private void setState(DefaultNode node, NodeState newState, String reason) {
            NodeState oldState = node.state;
            if (oldState != newState) {
                LOG.debug("[{}] Transitioning {} {}=>{} (because {})", new Object[]{NodeStateManager.this.logPrefix, node, oldState, newState, reason});
                node.state = newState;
                node.upSinceMillis = newState == NodeState.UP ? System.currentTimeMillis() : -1L;
                if (oldState == NodeState.UNKNOWN || newState != NodeState.UP) {
                    this.eventBus.fire(NodeStateEvent.changed(oldState, newState, node));
                } else {
                    this.metadataManager.refreshNode(node).whenComplete((success2, error2) -> {
                        try {
                            if (error2 != null) {
                                Loggers.warnWithException(LOG, "[{}] Error while refreshing info for {}", NodeStateManager.this.logPrefix, node, error2);
                            }
                            this.eventBus.fire(NodeStateEvent.changed(oldState, newState, node));
                        }
                        catch (Throwable t) {
                            Loggers.warnWithException(LOG, "[{}] Unexpected exception", NodeStateManager.this.logPrefix, t);
                        }
                    });
                }
            }
        }
    }
}

