/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing.helper;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.loadbalancing.helper.OptionalLocalDcHelper;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class MandatoryLocalDcHelper
extends OptionalLocalDcHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MandatoryLocalDcHelper.class);

    public MandatoryLocalDcHelper(@NonNull InternalDriverContext context, @NonNull DriverExecutionProfile profile, @NonNull String logPrefix) {
        super(context, profile, logPrefix);
    }

    @Override
    @NonNull
    public Optional<String> discoverLocalDc(@NonNull Map<UUID, Node> nodes2) {
        Optional<String> optionalLocalDc = super.discoverLocalDc(nodes2);
        if (optionalLocalDc.isPresent()) {
            return optionalLocalDc;
        }
        Set<DefaultNode> contactPoints = this.context.getMetadataManager().getContactPoints();
        if (this.context.getMetadataManager().wasImplicitContactPoint()) {
            assert (contactPoints.size() == 1);
            Node contactPoint = contactPoints.iterator().next();
            String localDc = contactPoint.getDatacenter();
            if (localDc != null) {
                LOG.debug("[{}] Local DC set from implicit contact point {}: {}", this.logPrefix, contactPoint, localDc);
                return Optional.of(localDc);
            }
            throw new IllegalStateException("The local DC could not be inferred from implicit contact point, please set it explicitly (see " + DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER.getPath() + " in the config, or set it programmatically with SessionBuilder.withLocalDatacenter)");
        }
        throw new IllegalStateException("Since you provided explicit contact points, the local DC must be explicitly set (see " + DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER.getPath() + " in the config, or set it programmatically with SessionBuilder.withLocalDatacenter). Current contact points are: " + this.formatNodesAndDcs(contactPoints) + ". Current DCs in this cluster are: " + this.formatDcs(nodes2.values()));
    }
}

