/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing.helper;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.loadbalancing.helper.NodeFilterHelper;
import com.datastax.oss.driver.internal.core.util.Reflection;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultNodeFilterHelper
implements NodeFilterHelper {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNodeFilterHelper.class);
    @NonNull
    protected final InternalDriverContext context;
    @NonNull
    protected final DriverExecutionProfile profile;
    @NonNull
    protected final String logPrefix;

    public DefaultNodeFilterHelper(@NonNull InternalDriverContext context, @NonNull DriverExecutionProfile profile, @NonNull String logPrefix) {
        this.context = context;
        this.profile = profile;
        this.logPrefix = logPrefix;
    }

    @Override
    @NonNull
    public Predicate<Node> createNodeFilter(@Nullable String localDc, @NonNull Map<UUID, Node> nodes2) {
        Predicate<Node> filterFromConfig = this.nodeFilterFromConfig();
        return node -> {
            if (localDc != null && !localDc.equals(node.getDatacenter())) {
                LOG.debug("[{}] Ignoring {} because it doesn't belong to the local DC {}", this.logPrefix, node, localDc);
                return false;
            }
            if (!filterFromConfig.test((Node)node)) {
                LOG.debug("[{}] Ignoring {} because it doesn't match the user-provided predicate", (Object)this.logPrefix, node);
                return false;
            }
            return true;
        };
    }

    @NonNull
    protected Predicate<Node> nodeFilterFromConfig() {
        Predicate filter2 = this.context.getNodeFilter(this.profile.getName());
        if (filter2 != null) {
            LOG.debug("[{}] Node filter set programmatically", (Object)this.logPrefix);
        } else {
            Predicate filterFromConfig;
            filter2 = filterFromConfig = Reflection.buildFromConfig(this.context, this.profile.getName(), DefaultDriverOption.LOAD_BALANCING_FILTER_CLASS, Predicate.class, new String[0]).orElse(INCLUDE_ALL_NODES);
            LOG.debug("[{}] Node filter set from configuration", (Object)this.logPrefix);
        }
        return filter2;
    }
}

