/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.PagingIterable;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class PagingIterableSpliterator<ElementT>
implements Spliterator<ElementT> {
    public static final int DEFAULT_CHUNK_SIZE = 128;
    private final PagingIterable<ElementT> iterable;
    private long estimatedSize;
    private final int chunkSize;
    private final int characteristics;

    @NonNull
    public static <ElementT> Builder<ElementT> builder(@NonNull PagingIterable<ElementT> iterable) {
        return new Builder<ElementT>(iterable);
    }

    public PagingIterableSpliterator(@NonNull PagingIterable<ElementT> iterable) {
        this(iterable, Long.MAX_VALUE, 128);
    }

    private PagingIterableSpliterator(@NonNull PagingIterable<ElementT> iterable, long estimatedSize, int chunkSize) {
        this.iterable = Objects.requireNonNull(iterable, "iterable cannot be null");
        this.estimatedSize = estimatedSize;
        this.chunkSize = chunkSize;
        this.characteristics = estimatedSize < Long.MAX_VALUE ? 17744 : 1296;
    }

    @Override
    public boolean tryAdvance(Consumer<? super ElementT> action2) {
        Objects.requireNonNull(action2, "action cannot be null");
        ElementT row = this.iterable.one();
        if (row == null) {
            return false;
        }
        action2.accept(row);
        return true;
    }

    @Override
    @Nullable
    public Spliterator<ElementT> trySplit() {
        if (this.estimatedSize != Long.MAX_VALUE && this.estimatedSize <= (long)this.chunkSize) {
            return null;
        }
        ElementT row = this.iterable.one();
        if (row == null) {
            return null;
        }
        Object[] array2 = new Object[this.chunkSize];
        int i = 0;
        do {
            array2[i++] = row;
        } while (i < this.chunkSize && (row = this.iterable.one()) != null);
        if (this.estimatedSize != Long.MAX_VALUE) {
            this.estimatedSize -= (long)i;
        }
        return Spliterators.spliterator(array2, 0, i, this.characteristics());
    }

    @Override
    public void forEachRemaining(Consumer<? super ElementT> action2) {
        this.iterable.iterator().forEachRemaining(action2);
    }

    @Override
    public long estimateSize() {
        return this.estimatedSize;
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }

    public static class Builder<ElementT> {
        private final PagingIterable<ElementT> iterable;
        private long estimatedSize = Long.MAX_VALUE;
        private int chunkSize = 128;

        Builder(@NonNull PagingIterable<ElementT> iterable) {
            this.iterable = iterable;
        }

        @NonNull
        public Builder<ElementT> withEstimatedSize(long estimatedSize) {
            Preconditions.checkArgument(estimatedSize >= 0L, "estimatedSize must be >= 0");
            this.estimatedSize = estimatedSize;
            return this;
        }

        @NonNull
        public Builder<ElementT> withChunkSize(int chunkSize) {
            Preconditions.checkArgument(chunkSize > 0, "chunkSize must be > 0");
            this.chunkSize = chunkSize;
            return this;
        }

        @NonNull
        public PagingIterableSpliterator<ElementT> build() {
            return new PagingIterableSpliterator(this.iterable, this.estimatedSize, this.chunkSize);
        }
    }
}

