/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableList;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultSimpleStatement
implements SimpleStatement {
    private final String query;
    private final List<Object> positionalValues;
    private final Map<CqlIdentifier, Object> namedValues;
    private final String executionProfileName;
    private final DriverExecutionProfile executionProfile;
    private final CqlIdentifier keyspace;
    private final CqlIdentifier routingKeyspace;
    private final ByteBuffer routingKey;
    private final Token routingToken;
    private final Map<String, ByteBuffer> customPayload;
    private final Boolean idempotent;
    private final boolean tracing;
    private final long timestamp;
    private final ByteBuffer pagingState;
    private final int pageSize;
    private final ConsistencyLevel consistencyLevel;
    private final ConsistencyLevel serialConsistencyLevel;
    private final Duration timeout;
    private final Node node;
    private final int nowInSeconds;

    public DefaultSimpleStatement(String query, List<Object> positionalValues, Map<CqlIdentifier, Object> namedValues, String executionProfileName, DriverExecutionProfile executionProfile, CqlIdentifier keyspace, CqlIdentifier routingKeyspace, ByteBuffer routingKey, Token routingToken, Map<String, ByteBuffer> customPayload, Boolean idempotent, boolean tracing2, long timestamp2, ByteBuffer pagingState, int pageSize, ConsistencyLevel consistencyLevel, ConsistencyLevel serialConsistencyLevel, Duration timeout, Node node, int nowInSeconds) {
        if (!positionalValues.isEmpty() && !namedValues.isEmpty()) {
            throw new IllegalArgumentException("Can't have both positional and named values");
        }
        this.query = query;
        this.positionalValues = NullAllowingImmutableList.copyOf(positionalValues);
        this.namedValues = NullAllowingImmutableMap.copyOf(namedValues);
        this.executionProfileName = executionProfileName;
        this.executionProfile = executionProfile;
        this.keyspace = keyspace;
        this.routingKeyspace = routingKeyspace;
        this.routingKey = routingKey;
        this.routingToken = routingToken;
        this.customPayload = customPayload;
        this.idempotent = idempotent;
        this.tracing = tracing2;
        this.timestamp = timestamp2;
        this.pagingState = pagingState;
        this.pageSize = pageSize;
        this.consistencyLevel = consistencyLevel;
        this.serialConsistencyLevel = serialConsistencyLevel;
        this.timeout = timeout;
        this.node = node;
        this.nowInSeconds = nowInSeconds;
    }

    @Override
    @NonNull
    public String getQuery() {
        return this.query;
    }

    @Override
    @NonNull
    public SimpleStatement setQuery(@NonNull String newQuery) {
        return new DefaultSimpleStatement(newQuery, this.positionalValues, this.namedValues, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    @NonNull
    public List<Object> getPositionalValues() {
        return this.positionalValues;
    }

    @Override
    @NonNull
    public SimpleStatement setPositionalValues(@NonNull List<Object> newPositionalValues) {
        return new DefaultSimpleStatement(this.query, newPositionalValues, this.namedValues, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    @NonNull
    public Map<CqlIdentifier, Object> getNamedValues() {
        return this.namedValues;
    }

    @Override
    @NonNull
    public SimpleStatement setNamedValuesWithIds(@NonNull Map<CqlIdentifier, Object> newNamedValues) {
        return new DefaultSimpleStatement(this.query, this.positionalValues, newNamedValues, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    @Nullable
    public String getExecutionProfileName() {
        return this.executionProfileName;
    }

    @Override
    @NonNull
    public SimpleStatement setExecutionProfileName(@Nullable String newConfigProfileName) {
        return new DefaultSimpleStatement(this.query, this.positionalValues, this.namedValues, newConfigProfileName, newConfigProfileName == null ? this.executionProfile : null, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    @Nullable
    public DriverExecutionProfile getExecutionProfile() {
        return this.executionProfile;
    }

    @Override
    @NonNull
    public SimpleStatement setExecutionProfile(@Nullable DriverExecutionProfile newProfile) {
        return new DefaultSimpleStatement(this.query, this.positionalValues, this.namedValues, newProfile == null ? this.executionProfileName : null, newProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    @Nullable
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @Override
    @NonNull
    public SimpleStatement setKeyspace(@Nullable CqlIdentifier newKeyspace) {
        return new DefaultSimpleStatement(this.query, this.positionalValues, this.namedValues, this.executionProfileName, this.executionProfile, newKeyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    @Nullable
    public CqlIdentifier getRoutingKeyspace() {
        return this.routingKeyspace;
    }

    @Override
    @NonNull
    public SimpleStatement setRoutingKeyspace(@Nullable CqlIdentifier newRoutingKeyspace) {
        return new DefaultSimpleStatement(this.query, this.positionalValues, this.namedValues, this.executionProfileName, this.executionProfile, this.keyspace, newRoutingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    @NonNull
    public SimpleStatement setNode(@Nullable Node newNode) {
        return new DefaultSimpleStatement(this.query, this.positionalValues, this.namedValues, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, newNode, this.nowInSeconds);
    }

    @Override
    @Nullable
    public Node getNode() {
        return this.node;
    }

    @Override
    @Nullable
    public ByteBuffer getRoutingKey() {
        return this.routingKey;
    }

    @Override
    @NonNull
    public SimpleStatement setRoutingKey(@Nullable ByteBuffer newRoutingKey) {
        return new DefaultSimpleStatement(this.query, this.positionalValues, this.namedValues, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, newRoutingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    @Nullable
    public Token getRoutingToken() {
        return this.routingToken;
    }

    @Override
    @NonNull
    public SimpleStatement setRoutingToken(@Nullable Token newRoutingToken) {
        return new DefaultSimpleStatement(this.query, this.positionalValues, this.namedValues, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, newRoutingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    @NonNull
    public Map<String, ByteBuffer> getCustomPayload() {
        return this.customPayload;
    }

    @Override
    @NonNull
    public SimpleStatement setCustomPayload(@NonNull Map<String, ByteBuffer> newCustomPayload) {
        return new DefaultSimpleStatement(this.query, this.positionalValues, this.namedValues, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, newCustomPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    @Nullable
    public Boolean isIdempotent() {
        return this.idempotent;
    }

    @Override
    @NonNull
    public SimpleStatement setIdempotent(@Nullable Boolean newIdempotence) {
        return new DefaultSimpleStatement(this.query, this.positionalValues, this.namedValues, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, newIdempotence, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    public boolean isTracing() {
        return this.tracing;
    }

    @Override
    @NonNull
    public SimpleStatement setTracing(boolean newTracing) {
        return new DefaultSimpleStatement(this.query, this.positionalValues, this.namedValues, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, newTracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    public long getQueryTimestamp() {
        return this.timestamp;
    }

    @Override
    @NonNull
    public SimpleStatement setQueryTimestamp(long newTimestamp) {
        return new DefaultSimpleStatement(this.query, this.positionalValues, this.namedValues, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, newTimestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    @Nullable
    public Duration getTimeout() {
        return this.timeout;
    }

    @Override
    @NonNull
    public SimpleStatement setTimeout(@Nullable Duration newTimeout) {
        return new DefaultSimpleStatement(this.query, this.positionalValues, this.namedValues, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, newTimeout, this.node, this.nowInSeconds);
    }

    @Override
    @Nullable
    public ByteBuffer getPagingState() {
        return this.pagingState;
    }

    @Override
    @NonNull
    public SimpleStatement setPagingState(@Nullable ByteBuffer newPagingState) {
        return new DefaultSimpleStatement(this.query, this.positionalValues, this.namedValues, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, newPagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    @NonNull
    public SimpleStatement setPageSize(int newPageSize) {
        return new DefaultSimpleStatement(this.query, this.positionalValues, this.namedValues, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, newPageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    @Nullable
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    @Override
    @NonNull
    public SimpleStatement setConsistencyLevel(@Nullable ConsistencyLevel newConsistencyLevel) {
        return new DefaultSimpleStatement(this.query, this.positionalValues, this.namedValues, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, newConsistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    @Nullable
    public ConsistencyLevel getSerialConsistencyLevel() {
        return this.serialConsistencyLevel;
    }

    @Override
    @NonNull
    public SimpleStatement setSerialConsistencyLevel(@Nullable ConsistencyLevel newSerialConsistencyLevel) {
        return new DefaultSimpleStatement(this.query, this.positionalValues, this.namedValues, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, newSerialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    public int getNowInSeconds() {
        return this.nowInSeconds;
    }

    @Override
    @NonNull
    public SimpleStatement setNowInSeconds(int newNowInSeconds) {
        return new DefaultSimpleStatement(this.query, this.positionalValues, this.namedValues, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, newNowInSeconds);
    }

    public static Map<CqlIdentifier, Object> wrapKeys(Map<String, Object> namedValues) {
        NullAllowingImmutableMap.Builder<CqlIdentifier, Object> builder = NullAllowingImmutableMap.builder();
        for (Map.Entry<String, Object> entry2 : namedValues.entrySet()) {
            builder.put(CqlIdentifier.fromCql(entry2.getKey()), entry2.getValue());
        }
        return builder.build();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DefaultSimpleStatement) {
            DefaultSimpleStatement that = (DefaultSimpleStatement)other;
            return this.query.equals(that.query) && this.positionalValues.equals(that.positionalValues) && this.namedValues.equals(that.namedValues) && Objects.equals(this.executionProfileName, that.executionProfileName) && Objects.equals(this.executionProfile, that.executionProfile) && Objects.equals(this.keyspace, that.keyspace) && Objects.equals(this.routingKeyspace, that.routingKeyspace) && Objects.equals(this.routingKey, that.routingKey) && Objects.equals(this.routingToken, that.routingToken) && Objects.equals(this.customPayload, that.customPayload) && Objects.equals(this.idempotent, that.idempotent) && this.tracing == that.tracing && this.timestamp == that.timestamp && Objects.equals(this.pagingState, that.pagingState) && this.pageSize == that.pageSize && Objects.equals(this.consistencyLevel, that.consistencyLevel) && Objects.equals(this.serialConsistencyLevel, that.serialConsistencyLevel) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.node, that.node) && this.nowInSeconds == that.nowInSeconds;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.query, this.positionalValues, this.namedValues, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }
}

