/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.protocol.internal.util.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultRow
implements Row,
Serializable {
    private final ColumnDefinitions definitions;
    private final List<ByteBuffer> data;
    private volatile transient AttachmentPoint attachmentPoint;

    public DefaultRow(ColumnDefinitions definitions, List<ByteBuffer> data2, AttachmentPoint attachmentPoint) {
        this.definitions = definitions;
        this.data = data2;
        this.attachmentPoint = attachmentPoint;
    }

    public DefaultRow(ColumnDefinitions definitions, List<ByteBuffer> data2) {
        this(definitions, data2, AttachmentPoint.NONE);
    }

    @Override
    @NonNull
    public ColumnDefinitions getColumnDefinitions() {
        return this.definitions;
    }

    @Override
    public int size() {
        return this.definitions.size();
    }

    @Override
    @NonNull
    public DataType getType(int i) {
        return this.definitions.get(i).getType();
    }

    @Override
    @NonNull
    public List<Integer> allIndicesOf(@NonNull CqlIdentifier id) {
        List<Integer> indices = this.definitions.allIndicesOf(id);
        if (indices.isEmpty()) {
            throw new IllegalArgumentException(id + " is not a column in this row");
        }
        return indices;
    }

    @Override
    public int firstIndexOf(@NonNull CqlIdentifier id) {
        int indexOf2 = this.definitions.firstIndexOf(id);
        if (indexOf2 == -1) {
            throw new IllegalArgumentException(id + " is not a column in this row");
        }
        return indexOf2;
    }

    @Override
    @NonNull
    public DataType getType(@NonNull CqlIdentifier id) {
        return this.definitions.get(this.firstIndexOf(id)).getType();
    }

    @Override
    @NonNull
    public List<Integer> allIndicesOf(@NonNull String name2) {
        List<Integer> indices = this.definitions.allIndicesOf(name2);
        if (indices.isEmpty()) {
            throw new IllegalArgumentException(name2 + " is not a column in this row");
        }
        return indices;
    }

    @Override
    public int firstIndexOf(@NonNull String name2) {
        int indexOf2 = this.definitions.firstIndexOf(name2);
        if (indexOf2 == -1) {
            throw new IllegalArgumentException(name2 + " is not a column in this row");
        }
        return indexOf2;
    }

    @Override
    @NonNull
    public DataType getType(@NonNull String name2) {
        return this.definitions.get(this.firstIndexOf(name2)).getType();
    }

    @Override
    @NonNull
    public CodecRegistry codecRegistry() {
        return this.attachmentPoint.getCodecRegistry();
    }

    @Override
    @NonNull
    public ProtocolVersion protocolVersion() {
        return this.attachmentPoint.getProtocolVersion();
    }

    @Override
    public boolean isDetached() {
        return this.attachmentPoint == AttachmentPoint.NONE;
    }

    @Override
    public void attach(@NonNull AttachmentPoint attachmentPoint) {
        this.attachmentPoint = attachmentPoint;
        this.definitions.attach(attachmentPoint);
    }

    @Override
    @Nullable
    public ByteBuffer getBytesUnsafe(int i) {
        return this.data.get(i);
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final ColumnDefinitions definitions;
        private final byte[][] values;

        SerializationProxy(DefaultRow row) {
            this.definitions = row.definitions;
            this.values = new byte[row.data.size()][];
            int i = 0;
            for (ByteBuffer buffer : row.data) {
                this.values[i] = buffer == null ? null : Bytes.getArray(buffer);
                ++i;
            }
        }

        private Object readResolve() {
            ArrayList<ByteBuffer> data2 = new ArrayList<ByteBuffer>(this.values.length);
            for (byte[] value2 : this.values) {
                data2.add(value2 == null ? null : ByteBuffer.wrap(value2));
            }
            return new DefaultRow(this.definitions, data2);
        }
    }
}

