/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.cql.QueryTrace;
import com.datastax.oss.driver.api.core.cql.TraceEvent;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultQueryTrace
implements QueryTrace {
    private final UUID tracingId;
    private final String requestType;
    private final int durationMicros;
    private final InetSocketAddress coordinator;
    private final Map<String, String> parameters;
    private final long startedAt;
    private final List<TraceEvent> events;

    public DefaultQueryTrace(UUID tracingId, String requestType, int durationMicros, InetSocketAddress coordinator, Map<String, String> parameters, long startedAt, List<TraceEvent> events2) {
        this.tracingId = tracingId;
        this.requestType = requestType;
        this.durationMicros = durationMicros;
        this.coordinator = coordinator;
        this.parameters = parameters;
        this.startedAt = startedAt;
        this.events = events2;
    }

    @Override
    @NonNull
    public UUID getTracingId() {
        return this.tracingId;
    }

    @Override
    @NonNull
    public String getRequestType() {
        return this.requestType;
    }

    @Override
    public int getDurationMicros() {
        return this.durationMicros;
    }

    @Override
    @Deprecated
    @NonNull
    public InetAddress getCoordinator() {
        return this.coordinator.getAddress();
    }

    @Override
    @NonNull
    public InetSocketAddress getCoordinatorAddress() {
        return this.coordinator;
    }

    @Override
    @NonNull
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public long getStartedAt() {
        return this.startedAt;
    }

    @Override
    @NonNull
    public List<TraceEvent> getEvents() {
        return this.events;
    }

    public String toString() {
        return String.format("%s [%s] - %d\u00b5s", this.requestType, this.tracingId, this.durationMicros);
    }
}

