/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PagingState;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.internal.core.data.ValuesHelper;
import com.datastax.oss.protocol.internal.util.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class DefaultPagingState
implements PagingState {
    private final ByteBuffer rawPagingState;
    private final byte[] hash;
    private final int protocolVersion;

    public DefaultPagingState(ByteBuffer rawPagingState, Statement<?> statement2, AttachmentPoint attachmentPoint) {
        this(rawPagingState, DefaultPagingState.hash(statement2, rawPagingState, attachmentPoint), attachmentPoint.getProtocolVersion().getCode());
    }

    private DefaultPagingState(ByteBuffer rawPagingState, byte[] hash2, int protocolVersion) {
        this.rawPagingState = rawPagingState;
        this.hash = hash2;
        this.protocolVersion = protocolVersion;
    }

    public static DefaultPagingState fromBytes(byte[] bytes2) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes2);
        short rawPagingStateLength = buffer.getShort();
        short hashLength = buffer.getShort();
        int length = rawPagingStateLength + hashLength + 2;
        int legacyLength = rawPagingStateLength + hashLength;
        if (buffer.remaining() != length && buffer.remaining() != legacyLength) {
            throw new IllegalArgumentException("Cannot deserialize paging state, invalid format. The serialized form was corrupted, or not initially generated from a PagingState object.");
        }
        byte[] rawPagingState = new byte[rawPagingStateLength];
        buffer.get(rawPagingState);
        byte[] hash2 = new byte[hashLength];
        buffer.get(hash2);
        int protocolVersion = buffer.hasRemaining() ? (int)buffer.getShort() : 2;
        return new DefaultPagingState(ByteBuffer.wrap(rawPagingState), hash2, protocolVersion);
    }

    @Override
    public byte[] toBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(this.rawPagingState.remaining() + this.hash.length + 6);
        buffer.putShort((short)this.rawPagingState.remaining());
        buffer.putShort((short)this.hash.length);
        buffer.put(this.rawPagingState.duplicate());
        buffer.put(this.hash);
        buffer.putShort((short)this.protocolVersion);
        buffer.rewind();
        return buffer.array();
    }

    public static DefaultPagingState fromString(String string2) {
        byte[] bytes2 = Bytes.getArray(Bytes.fromHexString("0x" + string2));
        return DefaultPagingState.fromBytes(bytes2);
    }

    public String toString() {
        return Bytes.toHexString(this.toBytes()).substring(2);
    }

    @Override
    public boolean matches(@NonNull Statement<?> statement2, @Nullable Session session) {
        AttachmentPoint attachmentPoint = session == null ? AttachmentPoint.NONE : session.getContext();
        byte[] actual = DefaultPagingState.hash(statement2, this.rawPagingState, attachmentPoint);
        return Arrays.equals(actual, this.hash);
    }

    @Override
    @NonNull
    public ByteBuffer getRawPagingState() {
        return this.rawPagingState;
    }

    private static byte[] hash(@NonNull Statement<?> statement2, ByteBuffer rawPagingState, @NonNull AttachmentPoint attachmentPoint) {
        MessageDigest messageDigest;
        assert (!(statement2 instanceof BatchStatement));
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("It looks like this JVM doesn't support MD5 digests, can't use the rich paging state feature", e);
        }
        if (statement2 instanceof BoundStatement) {
            BoundStatement boundStatement = (BoundStatement)statement2;
            String queryString = boundStatement.getPreparedStatement().getQuery();
            messageDigest.update(queryString.getBytes(Charset.defaultCharset()));
            for (ByteBuffer value2 : boundStatement.getValues()) {
                messageDigest.update(value2.duplicate());
            }
        } else {
            ByteBuffer encodedValue;
            SimpleStatement simpleStatement = (SimpleStatement)statement2;
            String queryString = simpleStatement.getQuery();
            messageDigest.update(queryString.getBytes(Charset.defaultCharset()));
            for (Object value3 : simpleStatement.getPositionalValues()) {
                encodedValue = ValuesHelper.encodeToDefaultCqlMapping(value3, attachmentPoint.getCodecRegistry(), attachmentPoint.getProtocolVersion());
                messageDigest.update(encodedValue);
            }
            for (Object value3 : simpleStatement.getNamedValues().values()) {
                encodedValue = ValuesHelper.encodeToDefaultCqlMapping(value3, attachmentPoint.getCodecRegistry(), attachmentPoint.getProtocolVersion());
                messageDigest.update(encodedValue);
            }
        }
        messageDigest.update(rawPagingState.duplicate());
        return messageDigest.digest();
    }
}

