/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.PagingState;
import com.datastax.oss.driver.api.core.cql.QueryTrace;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.DefaultPagingState;
import com.datastax.oss.driver.internal.core.cql.QueryTraceFetcher;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.protocol.internal.Frame;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultExecutionInfo
implements ExecutionInfo {
    private final Request request;
    private final Node coordinator;
    private final int speculativeExecutionCount;
    private final int successfulExecutionIndex;
    private final List<Map.Entry<Node, Throwable>> errors;
    private final ByteBuffer pagingState;
    private final UUID tracingId;
    private final int responseSizeInBytes;
    private final int compressedResponseSizeInBytes;
    private final List<String> warnings;
    private final Map<String, ByteBuffer> customPayload;
    private final boolean schemaInAgreement;
    private final DefaultSession session;
    private final InternalDriverContext context;
    private final DriverExecutionProfile executionProfile;

    public DefaultExecutionInfo(Request request, Node coordinator, int speculativeExecutionCount, int successfulExecutionIndex, List<Map.Entry<Node, Throwable>> errors, ByteBuffer pagingState, Frame frame, boolean schemaInAgreement, DefaultSession session, InternalDriverContext context, DriverExecutionProfile executionProfile) {
        this.request = request;
        this.coordinator = coordinator;
        this.speculativeExecutionCount = speculativeExecutionCount;
        this.successfulExecutionIndex = successfulExecutionIndex;
        this.errors = errors;
        this.pagingState = pagingState;
        this.tracingId = frame == null ? null : frame.tracingId;
        this.responseSizeInBytes = frame == null ? -1 : frame.size;
        this.compressedResponseSizeInBytes = frame == null ? -1 : frame.compressedSize;
        this.warnings = frame == null ? Collections.emptyList() : frame.warnings;
        this.customPayload = frame == null ? Collections.emptyMap() : frame.customPayload;
        this.schemaInAgreement = schemaInAgreement;
        this.session = session;
        this.context = context;
        this.executionProfile = executionProfile;
    }

    @Override
    @Deprecated
    @NonNull
    public Statement<?> getStatement() {
        return (Statement)this.request;
    }

    @Override
    @NonNull
    public Request getRequest() {
        return this.request;
    }

    @Override
    @Nullable
    public Node getCoordinator() {
        return this.coordinator;
    }

    @Override
    public int getSpeculativeExecutionCount() {
        return this.speculativeExecutionCount;
    }

    @Override
    public int getSuccessfulExecutionIndex() {
        return this.successfulExecutionIndex;
    }

    @Override
    @NonNull
    public List<Map.Entry<Node, Throwable>> getErrors() {
        return this.errors == null ? Collections.emptyList() : Collections.unmodifiableList(this.errors);
    }

    @Override
    @Nullable
    public ByteBuffer getPagingState() {
        return this.pagingState;
    }

    @Override
    @Nullable
    public PagingState getSafePagingState() {
        if (this.pagingState == null) {
            return null;
        }
        if (!(this.request instanceof Statement)) {
            throw new IllegalStateException("Only statements should have a paging state");
        }
        Statement statement2 = (Statement)this.request;
        return new DefaultPagingState(this.pagingState, statement2, this.session.getContext());
    }

    @Override
    @NonNull
    public List<String> getWarnings() {
        return this.warnings;
    }

    @Override
    @NonNull
    public Map<String, ByteBuffer> getIncomingPayload() {
        return this.customPayload;
    }

    @Override
    public boolean isSchemaInAgreement() {
        return this.schemaInAgreement;
    }

    @Override
    @Nullable
    public UUID getTracingId() {
        return this.tracingId;
    }

    @Override
    @NonNull
    public CompletionStage<QueryTrace> getQueryTraceAsync() {
        if (this.tracingId == null) {
            return CompletableFutures.failedFuture(new IllegalStateException("Tracing was disabled for this request"));
        }
        return new QueryTraceFetcher(this.tracingId, this.session, this.context, this.executionProfile).fetch();
    }

    @Override
    public int getResponseSizeInBytes() {
        return this.responseSizeInBytes;
    }

    @Override
    public int getCompressedResponseSizeInBytes() {
        return this.compressedResponseSizeInBytes;
    }
}

