/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.cql.PrepareRequest;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.CqlPrepareAsyncProcessor;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.session.RequestProcessor;
import com.datastax.oss.driver.internal.core.util.concurrent.BlockingOperation;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.shaded.guava.common.cache.Cache;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class CqlPrepareSyncProcessor
implements RequestProcessor<PrepareRequest, PreparedStatement> {
    private final CqlPrepareAsyncProcessor asyncProcessor;

    public CqlPrepareSyncProcessor(CqlPrepareAsyncProcessor asyncProcessor) {
        this.asyncProcessor = asyncProcessor;
    }

    @Override
    public boolean canProcess(Request request, GenericType<?> resultType) {
        return request instanceof PrepareRequest && resultType.equals(PrepareRequest.SYNC);
    }

    @Override
    public PreparedStatement process(PrepareRequest request, DefaultSession session, InternalDriverContext context, String sessionLogPrefix) {
        BlockingOperation.checkNotDriverThread();
        return CompletableFutures.getUninterruptibly(this.asyncProcessor.process(request, session, context, sessionLogPrefix));
    }

    public Cache<PrepareRequest, CompletableFuture<PreparedStatement>> getCache() {
        return this.asyncProcessor.getCache();
    }

    @Override
    public PreparedStatement newFailure(RuntimeException error2) {
        throw error2;
    }
}

