/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.cql.PrepareRequest;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.CqlPrepareHandler;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.session.RequestProcessor;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.shaded.guava.common.cache.Cache;
import com.datastax.oss.driver.shaded.guava.common.cache.CacheBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class CqlPrepareAsyncProcessor
implements RequestProcessor<PrepareRequest, CompletionStage<PreparedStatement>> {
    protected final Cache<PrepareRequest, CompletableFuture<PreparedStatement>> cache;

    public CqlPrepareAsyncProcessor() {
        this(CacheBuilder.newBuilder().weakValues().build());
    }

    protected CqlPrepareAsyncProcessor(Cache<PrepareRequest, CompletableFuture<PreparedStatement>> cache2) {
        this.cache = cache2;
    }

    @Override
    public boolean canProcess(Request request, GenericType<?> resultType) {
        return request instanceof PrepareRequest && resultType.equals(PrepareRequest.ASYNC);
    }

    @Override
    public CompletionStage<PreparedStatement> process(PrepareRequest request, DefaultSession session, InternalDriverContext context, String sessionLogPrefix) {
        try {
            CompletableFuture mine;
            CompletableFuture result2 = this.cache.getIfPresent(request);
            if (result2 == null && (result2 = this.cache.get(request, () -> CqlPrepareAsyncProcessor.lambda$process$0(mine = new CompletableFuture()))) == mine) {
                new CqlPrepareHandler(request, session, context, sessionLogPrefix).handle().whenComplete((preparedStatement, error2) -> {
                    if (error2 != null) {
                        mine.completeExceptionally((Throwable)error2);
                        this.cache.invalidate(request);
                    } else {
                        mine.complete(preparedStatement);
                    }
                });
            }
            return result2;
        }
        catch (ExecutionException e) {
            return CompletableFutures.failedFuture(e.getCause());
        }
    }

    @Override
    public CompletionStage<PreparedStatement> newFailure(RuntimeException error2) {
        return CompletableFutures.failedFuture(error2);
    }

    public Cache<PrepareRequest, CompletableFuture<PreparedStatement>> getCache() {
        return this.cache;
    }

    private static /* synthetic */ CompletableFuture lambda$process$0(CompletableFuture mine) throws Exception {
        return mine;
    }
}

