/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config.typesafe;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultDriverConfigLoader;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValueFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class DefaultProgrammaticDriverConfigLoaderBuilder
implements ProgrammaticDriverConfigLoaderBuilder {
    public static final Supplier<Config> DEFAULT_FALLBACK_SUPPLIER = () -> ConfigFactory.defaultApplication().withFallback(ConfigFactory.defaultReference(CqlSession.class.getClassLoader()));
    private final NullAllowingImmutableMap.Builder<String, Object> values = NullAllowingImmutableMap.builder();
    private final Supplier<Config> fallbackSupplier;
    private final String rootPath;
    private String currentProfileName = "default";

    public DefaultProgrammaticDriverConfigLoaderBuilder() {
        this(DEFAULT_FALLBACK_SUPPLIER, "datastax-java-driver");
    }

    public DefaultProgrammaticDriverConfigLoaderBuilder(@NonNull ClassLoader appClassLoader) {
        this(() -> ConfigFactory.defaultApplication(appClassLoader).withFallback(ConfigFactory.defaultReference(CqlSession.class.getClassLoader())), "datastax-java-driver");
    }

    public DefaultProgrammaticDriverConfigLoaderBuilder(@NonNull Supplier<Config> fallbackSupplier, @NonNull String rootPath) {
        this.fallbackSupplier = fallbackSupplier;
        this.rootPath = rootPath;
    }

    private ProgrammaticDriverConfigLoaderBuilder with(@NonNull DriverOption option2, @Nullable Object value2) {
        return this.with(option2.getPath(), value2);
    }

    private ProgrammaticDriverConfigLoaderBuilder with(@NonNull String path, @Nullable Object value2) {
        if (!"default".equals(this.currentProfileName)) {
            path = "profiles." + this.currentProfileName + "." + path;
        }
        if (!this.rootPath.isEmpty()) {
            path = this.rootPath + "." + path;
        }
        this.values.put(path, value2);
        return this;
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder startProfile(@NonNull String profileName) {
        this.currentProfileName = Objects.requireNonNull(profileName);
        return this;
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder endProfile() {
        this.currentProfileName = "default";
        return this;
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withBoolean(@NonNull DriverOption option2, boolean value2) {
        return this.with(option2, (Object)value2);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withBooleanList(@NonNull DriverOption option2, @NonNull List<Boolean> value2) {
        return this.with(option2, value2);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withInt(@NonNull DriverOption option2, int value2) {
        return this.with(option2, (Object)value2);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withIntList(@NonNull DriverOption option2, @NonNull List<Integer> value2) {
        return this.with(option2, value2);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withLong(@NonNull DriverOption option2, long value2) {
        return this.with(option2, (Object)value2);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withLongList(@NonNull DriverOption option2, @NonNull List<Long> value2) {
        return this.with(option2, value2);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withDouble(@NonNull DriverOption option2, double value2) {
        return this.with(option2, (Object)value2);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withDoubleList(@NonNull DriverOption option2, @NonNull List<Double> value2) {
        return this.with(option2, value2);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withString(@NonNull DriverOption option2, @NonNull String value2) {
        return this.with(option2, (Object)value2);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withStringList(@NonNull DriverOption option2, @NonNull List<String> value2) {
        return this.with(option2, value2);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withStringMap(@NonNull DriverOption option2, @NonNull Map<String, String> value2) {
        for (String key : value2.keySet()) {
            this.with(option2.getPath() + "." + key, (Object)value2.get(key));
        }
        return this;
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withBytes(@NonNull DriverOption option2, long value2) {
        return this.with(option2, (Object)value2);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withBytesList(@NonNull DriverOption option2, @NonNull List<Long> value2) {
        return this.with(option2, value2);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withDuration(@NonNull DriverOption option2, @NonNull Duration value2) {
        return this.with(option2, (Object)value2);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withDurationList(@NonNull DriverOption option2, @NonNull List<Duration> value2) {
        return this.with(option2, value2);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder without(@NonNull DriverOption option2) {
        return this.with(option2, null);
    }

    @Override
    @NonNull
    public DriverConfigLoader build() {
        return new DefaultDriverConfigLoader(() -> {
            ConfigFactory.invalidateCaches();
            Config programmaticConfig = this.buildConfig();
            Config config = ConfigFactory.defaultOverrides().withFallback(programmaticConfig).withFallback(this.fallbackSupplier.get()).resolve();
            return this.rootPath.isEmpty() ? config : config.getConfig(this.rootPath);
        });
    }

    private Config buildConfig() {
        Config config = ConfigFactory.empty();
        for (Map.Entry<String, Object> entry2 : this.values.build().entrySet()) {
            config = config.withValue(entry2.getKey(), ConfigValueFactory.fromAnyRef(entry2.getValue()));
        }
        return config;
    }
}

