/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config.typesafe;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.config.ConfigChangeEvent;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultDriverConfigLoaderBuilder;
import com.datastax.oss.driver.internal.core.config.typesafe.TypesafeDriverConfig;
import com.datastax.oss.driver.internal.core.context.EventBus;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.util.Loggers;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.internal.core.util.concurrent.RunOrSchedule;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultDriverConfigLoader
implements DriverConfigLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDriverConfigLoader.class);
    public static final String DEFAULT_ROOT_PATH = "datastax-java-driver";
    public static final Supplier<Config> DEFAULT_CONFIG_SUPPLIER = () -> {
        ConfigFactory.invalidateCaches();
        return ConfigFactory.defaultOverrides().withFallback(ConfigFactory.defaultApplication()).withFallback(ConfigFactory.defaultReference(CqlSession.class.getClassLoader())).resolve().getConfig(DEFAULT_ROOT_PATH);
    };
    private final Supplier<Config> configSupplier;
    private final TypesafeDriverConfig driverConfig;
    private final boolean supportsReloading;
    private volatile SingleThreaded singleThreaded;

    public DefaultDriverConfigLoader() {
        this(DEFAULT_CONFIG_SUPPLIER);
    }

    public DefaultDriverConfigLoader(@NonNull ClassLoader appClassLoader) {
        this(() -> {
            ConfigFactory.invalidateCaches();
            return ConfigFactory.defaultOverrides().withFallback(ConfigFactory.defaultApplication(appClassLoader)).withFallback(ConfigFactory.defaultReference(CqlSession.class.getClassLoader())).resolve().getConfig(DEFAULT_ROOT_PATH);
        });
    }

    public DefaultDriverConfigLoader(@NonNull Supplier<Config> configSupplier) {
        this(configSupplier, true);
    }

    public DefaultDriverConfigLoader(@NonNull Supplier<Config> configSupplier, boolean supportsReloading) {
        this.configSupplier = configSupplier;
        this.driverConfig = new TypesafeDriverConfig(configSupplier.get());
        this.supportsReloading = supportsReloading;
    }

    @Override
    @NonNull
    public DriverConfig getInitialConfig() {
        return this.driverConfig;
    }

    @Override
    public void onDriverInit(@NonNull DriverContext driverContext) {
        this.singleThreaded = new SingleThreaded((InternalDriverContext)driverContext);
    }

    @Override
    @NonNull
    public final CompletionStage<Boolean> reload() {
        if (this.supportsReloading) {
            CompletableFuture<Boolean> result2 = new CompletableFuture<Boolean>();
            RunOrSchedule.on(this.singleThreaded.adminExecutor, () -> this.singleThreaded.reload(result2));
            return result2;
        }
        return CompletableFutures.failedFuture(new UnsupportedOperationException("This instance of DefaultDriverConfigLoader does not support reloading"));
    }

    @Override
    public final boolean supportsReloading() {
        return this.supportsReloading;
    }

    @NonNull
    public Supplier<Config> getConfigSupplier() {
        return this.configSupplier;
    }

    @Override
    public void close() {
        SingleThreaded singleThreaded = this.singleThreaded;
        if (singleThreaded != null) {
            RunOrSchedule.on(singleThreaded.adminExecutor, () -> singleThreaded.close());
        }
    }

    @Deprecated
    @NonNull
    public static DefaultDriverConfigLoaderBuilder builder() {
        return new DefaultDriverConfigLoaderBuilder();
    }

    private class SingleThreaded {
        private final String logPrefix;
        private final EventExecutor adminExecutor;
        private final EventBus eventBus;
        private final DriverExecutionProfile config;
        private Duration reloadInterval;
        private ScheduledFuture<?> periodicTaskHandle;
        private boolean closeWasCalled;

        private SingleThreaded(InternalDriverContext context) {
            this.logPrefix = context.getSessionName();
            this.adminExecutor = context.getNettyOptions().adminEventExecutorGroup().next();
            this.eventBus = context.getEventBus();
            this.config = context.getConfig().getDefaultProfile();
            this.reloadInterval = context.getConfig().getDefaultProfile().getDuration(DefaultDriverOption.CONFIG_RELOAD_INTERVAL);
            RunOrSchedule.on(this.adminExecutor, this::schedulePeriodicReload);
        }

        private void schedulePeriodicReload() {
            assert (this.adminExecutor.inEventLoop());
            if (this.periodicTaskHandle != null) {
                this.periodicTaskHandle.cancel(false);
            }
            if (this.reloadInterval.isZero()) {
                LOG.debug("[{}] Reload interval is 0, disabling periodic reloading", (Object)this.logPrefix);
            } else {
                LOG.debug("[{}] Scheduling periodic reloading with interval {}", (Object)this.logPrefix, (Object)this.reloadInterval);
                this.periodicTaskHandle = this.adminExecutor.scheduleAtFixedRate(this::reloadInBackground, this.reloadInterval.toNanos(), this.reloadInterval.toNanos(), TimeUnit.NANOSECONDS);
            }
        }

        private void reload(CompletableFuture<Boolean> reloadedFuture) {
            assert (this.adminExecutor.inEventLoop());
            if (this.closeWasCalled) {
                if (reloadedFuture != null) {
                    reloadedFuture.completeExceptionally(new IllegalStateException("session is closing"));
                }
                return;
            }
            try {
                boolean changed = DefaultDriverConfigLoader.this.driverConfig.reload((Config)DefaultDriverConfigLoader.this.configSupplier.get());
                if (changed) {
                    LOG.info("[{}] Detected a configuration change", (Object)this.logPrefix);
                    this.eventBus.fire((Object)ConfigChangeEvent.INSTANCE);
                    Duration newReloadInterval = this.config.getDuration(DefaultDriverOption.CONFIG_RELOAD_INTERVAL);
                    if (!newReloadInterval.equals(this.reloadInterval)) {
                        this.reloadInterval = newReloadInterval;
                        this.schedulePeriodicReload();
                    }
                } else {
                    LOG.debug("[{}] Reloaded configuration but it hasn't changed", (Object)this.logPrefix);
                }
                if (reloadedFuture != null) {
                    reloadedFuture.complete(changed);
                }
            }
            catch (Error | RuntimeException e) {
                if (reloadedFuture != null) {
                    reloadedFuture.completeExceptionally(e);
                }
                Loggers.warnWithException(LOG, "[{}] Unexpected exception during scheduled reload", this.logPrefix, e);
            }
        }

        private void reloadInBackground() {
            this.reload(null);
        }

        private void close() {
            assert (this.adminExecutor.inEventLoop());
            if (this.closeWasCalled) {
                return;
            }
            this.closeWasCalled = true;
            if (this.periodicTaskHandle != null) {
                this.periodicTaskHandle.cancel(false);
            }
        }
    }
}

