/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config.map;

import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSortedSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;

public class MapBasedDriverExecutionProfile
implements DriverExecutionProfile {
    private final String profileName;
    private final Map<DriverOption, Object> profile;
    private final Map<DriverOption, Object> defaultProfile;

    public MapBasedDriverExecutionProfile(Map<String, Map<DriverOption, Object>> optionsMap, String profileName) {
        this(profileName, optionsMap.get(profileName), profileName.equals("default") ? Collections.emptyMap() : optionsMap.get("default"));
        Preconditions.checkArgument(optionsMap.containsKey(profileName), "Unknown profile '%s'. Check your configuration.", (Object)profileName);
    }

    public MapBasedDriverExecutionProfile(String profileName, Map<DriverOption, Object> profile, Map<DriverOption, Object> defaultProfile) {
        this.profileName = profileName;
        this.profile = profile;
        this.defaultProfile = defaultProfile;
    }

    @Override
    @NonNull
    public String getName() {
        return this.profileName;
    }

    @Override
    public boolean isDefined(@NonNull DriverOption option2) {
        return this.profile.containsKey(option2) || this.defaultProfile.containsKey(option2);
    }

    @NonNull
    private <T> T get(@NonNull DriverOption option2) {
        Object value2 = this.profile.getOrDefault(option2, this.defaultProfile.get(option2));
        if (value2 == null) {
            throw new IllegalArgumentException("Missing configuration option " + option2.getPath());
        }
        return (T)value2;
    }

    @Override
    public boolean getBoolean(@NonNull DriverOption option2) {
        return (Boolean)this.get(option2);
    }

    @Override
    @NonNull
    public List<Boolean> getBooleanList(@NonNull DriverOption option2) {
        return (List)this.get(option2);
    }

    @Override
    public int getInt(@NonNull DriverOption option2) {
        return (Integer)this.get(option2);
    }

    @Override
    @NonNull
    public List<Integer> getIntList(@NonNull DriverOption option2) {
        return (List)this.get(option2);
    }

    @Override
    public long getLong(@NonNull DriverOption option2) {
        return (Long)this.get(option2);
    }

    @Override
    @NonNull
    public List<Long> getLongList(@NonNull DriverOption option2) {
        return (List)this.get(option2);
    }

    @Override
    public double getDouble(@NonNull DriverOption option2) {
        return (Double)this.get(option2);
    }

    @Override
    @NonNull
    public List<Double> getDoubleList(@NonNull DriverOption option2) {
        return (List)this.get(option2);
    }

    @Override
    @NonNull
    public String getString(@NonNull DriverOption option2) {
        return (String)this.get(option2);
    }

    @Override
    @NonNull
    public List<String> getStringList(@NonNull DriverOption option2) {
        return (List)this.get(option2);
    }

    @Override
    @NonNull
    public Map<String, String> getStringMap(@NonNull DriverOption option2) {
        return (Map)this.get(option2);
    }

    @Override
    public long getBytes(@NonNull DriverOption option2) {
        return (Long)this.get(option2);
    }

    @Override
    @NonNull
    public List<Long> getBytesList(DriverOption option2) {
        return (List)this.get(option2);
    }

    @Override
    @NonNull
    public Duration getDuration(@NonNull DriverOption option2) {
        return (Duration)this.get(option2);
    }

    @Override
    @NonNull
    public List<Duration> getDurationList(@NonNull DriverOption option2) {
        return (List)this.get(option2);
    }

    @Override
    @NonNull
    public SortedSet<Map.Entry<String, Object>> entrySet() {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy(Map.Entry.comparingByKey());
        for (Map map2 : ImmutableList.of(this.profile, this.defaultProfile)) {
            for (Map.Entry entry2 : map2.entrySet()) {
                builder.add(new AbstractMap.SimpleEntry(((DriverOption)entry2.getKey()).getPath(), entry2.getValue()));
            }
        }
        return builder.build();
    }
}

