/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config;

import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSortedSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.function.BiFunction;

public class DerivedExecutionProfile
implements DriverExecutionProfile {
    private static final Object NO_VALUE = new Object();
    private final DriverExecutionProfile baseProfile;
    private final Map<DriverOption, Object> overrides;

    public static DerivedExecutionProfile with(DriverExecutionProfile baseProfile, DriverOption option2, Object value2) {
        if (baseProfile instanceof DerivedExecutionProfile) {
            DerivedExecutionProfile previousDerived = (DerivedExecutionProfile)baseProfile;
            ImmutableMap.Builder<DriverOption, Object> newOverrides = ImmutableMap.builder();
            for (Map.Entry<DriverOption, Object> override : previousDerived.overrides.entrySet()) {
                if (override.getKey().equals(option2)) continue;
                newOverrides.put(override.getKey(), override.getValue());
            }
            newOverrides.put(option2, value2);
            return new DerivedExecutionProfile(previousDerived.baseProfile, newOverrides.build());
        }
        return new DerivedExecutionProfile(baseProfile, ImmutableMap.of(option2, value2));
    }

    public static DerivedExecutionProfile without(DriverExecutionProfile baseProfile, DriverOption option2) {
        return DerivedExecutionProfile.with(baseProfile, option2, NO_VALUE);
    }

    public DerivedExecutionProfile(DriverExecutionProfile baseProfile, Map<DriverOption, Object> overrides) {
        this.baseProfile = baseProfile;
        this.overrides = overrides;
    }

    @Override
    @NonNull
    public String getName() {
        return this.baseProfile.getName();
    }

    @Override
    public boolean isDefined(@NonNull DriverOption option2) {
        if (this.overrides.containsKey(option2)) {
            return this.overrides.get(option2) != NO_VALUE;
        }
        return this.baseProfile.isDefined(option2);
    }

    @Override
    public boolean getBoolean(@NonNull DriverOption option2) {
        return this.get(option2, DriverExecutionProfile::getBoolean);
    }

    @Override
    @NonNull
    public List<Boolean> getBooleanList(@NonNull DriverOption option2) {
        return this.get(option2, DriverExecutionProfile::getBooleanList);
    }

    @Override
    public int getInt(@NonNull DriverOption option2) {
        return this.get(option2, DriverExecutionProfile::getInt);
    }

    @Override
    @NonNull
    public List<Integer> getIntList(@NonNull DriverOption option2) {
        return this.get(option2, DriverExecutionProfile::getIntList);
    }

    @Override
    public long getLong(@NonNull DriverOption option2) {
        return this.get(option2, DriverExecutionProfile::getLong);
    }

    @Override
    @NonNull
    public List<Long> getLongList(@NonNull DriverOption option2) {
        return this.get(option2, DriverExecutionProfile::getLongList);
    }

    @Override
    public double getDouble(@NonNull DriverOption option2) {
        return this.get(option2, DriverExecutionProfile::getDouble);
    }

    @Override
    @NonNull
    public List<Double> getDoubleList(@NonNull DriverOption option2) {
        return this.get(option2, DriverExecutionProfile::getDoubleList);
    }

    @Override
    @NonNull
    public String getString(@NonNull DriverOption option2) {
        return this.get(option2, DriverExecutionProfile::getString);
    }

    @Override
    @NonNull
    public List<String> getStringList(@NonNull DriverOption option2) {
        return this.get(option2, DriverExecutionProfile::getStringList);
    }

    @Override
    @NonNull
    public Map<String, String> getStringMap(@NonNull DriverOption option2) {
        return this.get(option2, DriverExecutionProfile::getStringMap);
    }

    @Override
    public long getBytes(@NonNull DriverOption option2) {
        return this.get(option2, DriverExecutionProfile::getBytes);
    }

    @Override
    @NonNull
    public List<Long> getBytesList(DriverOption option2) {
        return this.get(option2, DriverExecutionProfile::getBytesList);
    }

    @Override
    @NonNull
    public Duration getDuration(@NonNull DriverOption option2) {
        return this.get(option2, DriverExecutionProfile::getDuration);
    }

    @Override
    @NonNull
    public List<Duration> getDurationList(@NonNull DriverOption option2) {
        return this.get(option2, DriverExecutionProfile::getDurationList);
    }

    @NonNull
    private <ValueT> ValueT get(@NonNull DriverOption option2, BiFunction<DriverExecutionProfile, DriverOption, ValueT> getter2) {
        Object value2 = this.overrides.get(option2);
        if (value2 == null) {
            value2 = getter2.apply(this.baseProfile, option2);
        }
        if (value2 == null || value2 == NO_VALUE) {
            throw new IllegalArgumentException("Missing configuration option " + option2.getPath());
        }
        return (ValueT)value2;
    }

    @Override
    @NonNull
    public SortedSet<Map.Entry<String, Object>> entrySet() {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy(Map.Entry.comparingByKey());
        for (Map.Entry<DriverOption, Object> entry2 : this.overrides.entrySet()) {
            if (entry2.getValue() == NO_VALUE) continue;
            builder.add(new AbstractMap.SimpleEntry<String, Object>(entry2.getKey().getPath(), entry2.getValue()));
        }
        builder.addAll(this.baseProfile.entrySet());
        return builder.build();
    }
}

