/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.internal.core.channel.InFlightHandler;
import com.datastax.oss.driver.internal.core.channel.ResponseCallback;
import com.datastax.oss.driver.internal.core.channel.WriteCoalescer;
import com.datastax.oss.driver.internal.core.util.concurrent.UncaughtExceptions;
import com.datastax.oss.protocol.internal.Message;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoop;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DriverChannel {
    static final AttributeKey<String> CLUSTER_NAME_KEY = AttributeKey.newInstance("cluster_name");
    static final AttributeKey<Map<String, List<String>>> OPTIONS_KEY = AttributeKey.newInstance("options");
    static final Object GRACEFUL_CLOSE_MESSAGE = new String("GRACEFUL_CLOSE_MESSAGE");
    static final Object FORCEFUL_CLOSE_MESSAGE = new String("FORCEFUL_CLOSE_MESSAGE");
    private final EndPoint endPoint;
    private final Channel channel;
    private final InFlightHandler inFlightHandler;
    private final WriteCoalescer writeCoalescer;
    private final ProtocolVersion protocolVersion;
    private final AtomicBoolean closing = new AtomicBoolean();
    private final AtomicBoolean forceClosing = new AtomicBoolean();

    DriverChannel(EndPoint endPoint, Channel channel, WriteCoalescer writeCoalescer, ProtocolVersion protocolVersion) {
        this.endPoint = endPoint;
        this.channel = channel;
        this.inFlightHandler = channel.pipeline().get(InFlightHandler.class);
        this.writeCoalescer = writeCoalescer;
        this.protocolVersion = protocolVersion;
    }

    public Future<Void> write(Message request, boolean tracing2, Map<String, ByteBuffer> customPayload, ResponseCallback responseCallback) {
        if (this.closing.get()) {
            return this.channel.newFailedFuture(new IllegalStateException("Driver channel is closing"));
        }
        RequestMessage message = new RequestMessage(request, tracing2, customPayload, responseCallback);
        return this.writeCoalescer.writeAndFlush(this.channel, message);
    }

    public void cancel(ResponseCallback responseCallback) {
        this.writeCoalescer.writeAndFlush(this.channel, responseCallback).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)UncaughtExceptions::log));
    }

    public Future<Void> setKeyspace(CqlIdentifier newKeyspace) {
        Promise<Void> promise = this.channel.eventLoop().newPromise();
        this.channel.pipeline().fireUserEventTriggered(new SetKeyspaceEvent(newKeyspace, promise));
        return promise;
    }

    public String getClusterName() {
        return this.channel.attr(CLUSTER_NAME_KEY).get();
    }

    public Map<String, List<String>> getOptions() {
        return this.channel.attr(OPTIONS_KEY).get();
    }

    public int getAvailableIds() {
        return this.inFlightHandler.getAvailableIds();
    }

    public boolean preAcquireId() {
        return this.inFlightHandler.preAcquireId();
    }

    public int getInFlight() {
        return this.inFlightHandler.getInFlight();
    }

    public int getOrphanedIds() {
        return this.inFlightHandler.getOrphanIds();
    }

    public EventLoop eventLoop() {
        return this.channel.eventLoop();
    }

    public ProtocolVersion protocolVersion() {
        return this.protocolVersion;
    }

    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    public SocketAddress localAddress() {
        return this.channel.localAddress();
    }

    public ChannelConfig config() {
        return this.channel.config();
    }

    public Future<Void> close() {
        if (this.closing.compareAndSet(false, true) && this.channel.isOpen()) {
            this.writeCoalescer.writeAndFlush(this.channel, GRACEFUL_CLOSE_MESSAGE).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)UncaughtExceptions::log));
        }
        return this.channel.closeFuture();
    }

    public Future<Void> forceClose() {
        this.close();
        if (this.forceClosing.compareAndSet(false, true) && this.channel.isOpen()) {
            this.writeCoalescer.writeAndFlush(this.channel, FORCEFUL_CLOSE_MESSAGE).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)UncaughtExceptions::log));
        }
        return this.channel.closeFuture();
    }

    public ChannelFuture closeStartedFuture() {
        return this.inFlightHandler.closeStartedFuture;
    }

    public ChannelFuture closeFuture() {
        return this.channel.closeFuture();
    }

    public String toString() {
        return this.channel.toString();
    }

    static class SetKeyspaceEvent {
        final CqlIdentifier keyspaceName;
        final Promise<Void> promise;

        public SetKeyspaceEvent(CqlIdentifier keyspaceName, Promise<Void> promise) {
            this.keyspaceName = keyspaceName;
            this.promise = promise;
        }
    }

    static class RequestMessage {
        final Message request;
        final boolean tracing;
        final Map<String, ByteBuffer> customPayload;
        final ResponseCallback responseCallback;

        RequestMessage(Message message, boolean tracing2, Map<String, ByteBuffer> customPayload, ResponseCallback responseCallback) {
            this.request = message;
            this.tracing = tracing2;
            this.customPayload = customPayload;
            this.responseCallback = responseCallback;
        }
    }
}

