/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.adminrequest;

import com.datastax.oss.driver.api.core.DriverTimeoutException;
import com.datastax.oss.driver.api.core.RequestThrottlingException;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.api.core.session.throttling.RequestThrottler;
import com.datastax.oss.driver.api.core.session.throttling.Throttled;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRequestHandler;
import com.datastax.oss.driver.internal.core.adminrequest.AdminResult;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.Result;
import com.datastax.oss.protocol.internal.response.result.Prepared;
import com.datastax.oss.protocol.internal.response.result.Rows;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ThrottledAdminRequestHandler<ResultT>
extends AdminRequestHandler<ResultT>
implements Throttled {
    private final long startTimeNanos = System.nanoTime();
    private final RequestThrottler throttler;
    private final SessionMetricUpdater metricUpdater;

    public static ThrottledAdminRequestHandler<AdminResult> query(DriverChannel channel, boolean shouldPreAcquireId, Message message, Map<String, ByteBuffer> customPayload, Duration timeout, RequestThrottler throttler, SessionMetricUpdater metricUpdater, String logPrefix, String debugString) {
        return new ThrottledAdminRequestHandler<AdminResult>(channel, shouldPreAcquireId, message, customPayload, timeout, throttler, metricUpdater, logPrefix, debugString, Rows.class);
    }

    public static ThrottledAdminRequestHandler<ByteBuffer> prepare(DriverChannel channel, boolean shouldPreAcquireId, Message message, Map<String, ByteBuffer> customPayload, Duration timeout, RequestThrottler throttler, SessionMetricUpdater metricUpdater, String logPrefix) {
        return new ThrottledAdminRequestHandler<ByteBuffer>(channel, shouldPreAcquireId, message, customPayload, timeout, throttler, metricUpdater, logPrefix, message.toString(), Prepared.class);
    }

    protected ThrottledAdminRequestHandler(DriverChannel channel, boolean preAcquireId, Message message, Map<String, ByteBuffer> customPayload, Duration timeout, RequestThrottler throttler, SessionMetricUpdater metricUpdater, String logPrefix, String debugString, Class<? extends Result> expectedResponseType) {
        super(channel, preAcquireId, message, customPayload, timeout, logPrefix, debugString, expectedResponseType);
        this.throttler = throttler;
        this.metricUpdater = metricUpdater;
    }

    @Override
    public CompletionStage<ResultT> start() {
        this.throttler.register(this);
        return this.result;
    }

    @Override
    public void onThrottleReady(boolean wasDelayed) {
        if (wasDelayed) {
            this.metricUpdater.updateTimer(DefaultSessionMetric.THROTTLING_DELAY, null, System.nanoTime() - this.startTimeNanos, TimeUnit.NANOSECONDS);
        }
        super.start();
    }

    @Override
    public void onThrottleFailure(@NonNull RequestThrottlingException error2) {
        this.metricUpdater.incrementCounter(DefaultSessionMetric.THROTTLING_ERRORS, null);
        this.setFinalError(error2);
    }

    @Override
    protected boolean setFinalResult(ResultT result2) {
        boolean wasSet = super.setFinalResult(result2);
        if (wasSet) {
            this.throttler.signalSuccess(this);
        }
        return wasSet;
    }

    @Override
    protected boolean setFinalError(Throwable error2) {
        boolean wasSet = super.setFinalError(error2);
        if (wasSet) {
            if (error2 instanceof DriverTimeoutException) {
                this.throttler.signalTimeout(this);
            } else if (!(error2 instanceof RequestThrottlingException)) {
                this.throttler.signalError(this, error2);
            }
        }
        return wasSet;
    }
}

