/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core;

import com.datastax.oss.driver.api.core.MavenCoordinates;
import com.datastax.oss.driver.api.core.Version;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMavenCoordinates
implements MavenCoordinates {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMavenCoordinates.class);
    private final String name;
    private final String groupId;
    private final String artifactId;
    private final Version version;

    public static MavenCoordinates buildFromResourceAndPrint(URL resource2) {
        DefaultMavenCoordinates info2 = DefaultMavenCoordinates.buildFromResource(resource2);
        LOG.info("{}", (Object)info2);
        return info2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DefaultMavenCoordinates buildFromResource(URL resource2) {
        try (InputStreamReader reader = new InputStreamReader(resource2.openStream(), StandardCharsets.UTF_8);){
            Properties props = new Properties();
            props.load(reader);
            String name2 = props.getProperty("driver.name");
            String groupId = props.getProperty("driver.groupId");
            String artifactId = props.getProperty("driver.artifactId");
            String version = props.getProperty("driver.version");
            if (ByteBuf.class.getPackage().getName().contains("com.datastax.oss.driver.shaded")) {
                artifactId = artifactId + "-shaded";
            }
            DefaultMavenCoordinates defaultMavenCoordinates = new DefaultMavenCoordinates(name2, groupId, artifactId, Version.parse(version));
            return defaultMavenCoordinates;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public DefaultMavenCoordinates(String name2, String groupId, String artifactId, Version version) {
        this.name = name2;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    @NonNull
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @NonNull
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    @NonNull
    public Version getVersion() {
        return this.version;
    }

    public String toString() {
        return String.format("%s (%s:%s) version %s", this.name, this.groupId, this.artifactId, this.version);
    }
}

