/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core;

import com.datastax.oss.driver.api.core.AsyncPagingIterable;
import com.datastax.oss.driver.api.core.MappedAsyncPagingIterable;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.shaded.guava.common.collect.AbstractIterator;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public class AsyncPagingIterableWrapper<SourceT, TargetT>
implements MappedAsyncPagingIterable<TargetT> {
    private final AsyncPagingIterable<SourceT, ?> source;
    private final Function<? super SourceT, ? extends TargetT> elementMapper;
    private final Iterable<TargetT> currentPage;

    public AsyncPagingIterableWrapper(AsyncPagingIterable<SourceT, ?> source, final Function<? super SourceT, ? extends TargetT> elementMapper) {
        this.source = source;
        this.elementMapper = elementMapper;
        final Iterator<SourceT> sourceIterator = source.currentPage().iterator();
        AbstractIterator iterator2 = new AbstractIterator<TargetT>(){

            @Override
            protected TargetT computeNext() {
                return sourceIterator.hasNext() ? elementMapper.apply(sourceIterator.next()) : this.endOfData();
            }
        };
        this.currentPage = () -> iterator2;
    }

    @Override
    @NonNull
    public ColumnDefinitions getColumnDefinitions() {
        return this.source.getColumnDefinitions();
    }

    @Override
    @NonNull
    public ExecutionInfo getExecutionInfo() {
        return this.source.getExecutionInfo();
    }

    @Override
    public int remaining() {
        return this.source.remaining();
    }

    @Override
    @NonNull
    public Iterable<TargetT> currentPage() {
        return this.currentPage;
    }

    @Override
    public boolean hasMorePages() {
        return this.source.hasMorePages();
    }

    @Override
    @NonNull
    public CompletionStage<MappedAsyncPagingIterable<TargetT>> fetchNextPage() throws IllegalStateException {
        return this.source.fetchNextPage().thenApply(nextSource -> new AsyncPagingIterableWrapper<SourceT, TargetT>(nextSource, this.elementMapper));
    }

    @Override
    public boolean wasApplied() {
        return this.source.wasApplied();
    }
}

