/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.uuid;

import com.datastax.oss.driver.internal.core.os.Native;
import com.datastax.oss.driver.internal.core.util.Loggers;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.base.Charsets;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Uuids {
    public static final String PID_SYSTEM_PROPERTY = "com.datastax.oss.driver.PID";
    public static final UUID NAMESPACE_URL = UUID.fromString("6ba7b811-9dad-11d1-80b4-00c04fd430c8");
    public static final UUID NAMESPACE_DNS = UUID.fromString("6ba7b810-9dad-11d1-80b4-00c04fd430c8");
    public static final UUID NAMESPACE_OID = UUID.fromString("6ba7b812-9dad-11d1-80b4-00c04fd430c8");
    public static final UUID NAMESPACE_X500 = UUID.fromString("6ba7b814-9dad-11d1-80b4-00c04fd430c8");
    private static final Logger LOG = LoggerFactory.getLogger(Uuids.class);
    private static final long START_EPOCH = Uuids.makeEpoch();
    private static final ClockSeqAndNodeContainer CLOCK_SEQ_AND_NODE = new ClockSeqAndNodeContainer();
    private static final long MIN_CLOCK_SEQ_AND_NODE = -9187201950435737472L;
    private static final long MAX_CLOCK_SEQ_AND_NODE = 0x7F7F7F7F7F7F7F7FL;
    private static final AtomicLong lastTimestamp = new AtomicLong(0L);

    private Uuids() {
    }

    private static long makeEpoch() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT-0"));
        c.set(1, 1582);
        c.set(2, 9);
        c.set(5, 15);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTimeInMillis();
    }

    private static long makeNode() {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            for (String address : Uuids.getAllLocalAddresses()) {
                Uuids.update(digest, address);
            }
            Properties props = System.getProperties();
            Uuids.update(digest, props.getProperty("java.vendor"));
            Uuids.update(digest, props.getProperty("java.vendor.url"));
            Uuids.update(digest, props.getProperty("java.version"));
            Uuids.update(digest, props.getProperty("os.arch"));
            Uuids.update(digest, props.getProperty("os.name"));
            Uuids.update(digest, props.getProperty("os.version"));
            Uuids.update(digest, Uuids.getProcessPiece());
            byte[] hash2 = digest.digest();
            long node = 0L;
            for (int i = 0; i < 6; ++i) {
                node |= (0xFFL & (long)hash2[i]) << i * 8;
            }
            return node | 0x10000000000L;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getProcessPiece() {
        ClassLoader loader;
        Integer pid = null;
        String pidProperty = System.getProperty(PID_SYSTEM_PROPERTY);
        if (pidProperty != null) {
            try {
                pid = Integer.parseInt(pidProperty);
                LOG.info("PID obtained from System property {}: {}", (Object)PID_SYSTEM_PROPERTY, (Object)pid);
            }
            catch (NumberFormatException e) {
                LOG.warn("Incorrect integer specified for PID in System property {}: {}", (Object)PID_SYSTEM_PROPERTY, (Object)pidProperty);
            }
        }
        if (pid == null && Native.isGetProcessIdAvailable()) {
            try {
                pid = Native.getProcessId();
                LOG.info("PID obtained through native call to getpid(): {}", (Object)pid);
            }
            catch (Exception e) {
                Loggers.warnWithException(LOG, "Native call to getpid() failed", e);
            }
        }
        if (pid == null) {
            try {
                String pidJmx = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
                pid = Integer.parseInt(pidJmx);
                LOG.info("PID obtained through JMX: {}", (Object)pid);
            }
            catch (Exception e) {
                Loggers.warnWithException(LOG, "Failed to obtain PID from JMX", e);
            }
        }
        if (pid == null) {
            pid = new Random().nextInt();
            LOG.warn("Could not determine PID, falling back to a random integer: {}", (Object)pid);
        }
        int loaderId = (loader = Uuids.class.getClassLoader()) != null ? System.identityHashCode(loader) : 0;
        return Integer.toHexString(pid) + Integer.toHexString(loaderId);
    }

    private static void update(MessageDigest digest, String value2) {
        if (value2 != null) {
            digest.update(value2.getBytes(Charsets.UTF_8));
        }
    }

    private static long makeClockSeqAndNode() {
        long clock = new Random(System.currentTimeMillis()).nextLong();
        long node = Uuids.makeNode();
        long lsb = 0L;
        lsb |= (clock & 0x3FFFL) << 48;
        lsb |= Long.MIN_VALUE;
        return lsb |= node;
    }

    @NonNull
    public static UUID random() {
        return UUID.randomUUID();
    }

    @NonNull
    public static UUID nameBased(@NonNull UUID namespace, @NonNull String name2) {
        Objects.requireNonNull(name2, "name cannot be null");
        return Uuids.nameBased(namespace, name2.getBytes(StandardCharsets.UTF_8));
    }

    @NonNull
    public static UUID nameBased(@NonNull UUID namespace, @NonNull byte[] name2) {
        return Uuids.nameBased(namespace, name2, 3);
    }

    @NonNull
    public static UUID nameBased(@NonNull UUID namespace, @NonNull String name2, int version) {
        Objects.requireNonNull(name2, "name cannot be null");
        return Uuids.nameBased(namespace, name2.getBytes(StandardCharsets.UTF_8), version);
    }

    @NonNull
    public static UUID nameBased(@NonNull UUID namespace, @NonNull byte[] name2, int version) {
        Objects.requireNonNull(namespace, "namespace cannot be null");
        Objects.requireNonNull(name2, "name cannot be null");
        MessageDigest md = Uuids.newMessageDigest(version);
        md.update(Uuids.toBytes(namespace));
        md.update(name2);
        return Uuids.buildNamedUuid(md.digest(), version);
    }

    @NonNull
    public static UUID nameBased(@NonNull byte[] namespaceAndName) {
        return Uuids.nameBased(namespaceAndName, 3);
    }

    @NonNull
    public static UUID nameBased(@NonNull byte[] namespaceAndName, int version) {
        Objects.requireNonNull(namespaceAndName, "namespaceAndName cannot be null");
        if (namespaceAndName.length < 16) {
            throw new IllegalArgumentException("namespaceAndName must be at least 16 bytes long");
        }
        MessageDigest md = Uuids.newMessageDigest(version);
        md.update(namespaceAndName);
        return Uuids.buildNamedUuid(md.digest(), version);
    }

    @NonNull
    private static MessageDigest newMessageDigest(int version) {
        if (version != 3 && version != 5) {
            throw new IllegalArgumentException("Invalid name-based UUID version, expecting 3 or 5, got: " + version);
        }
        String algorithm = version == 3 ? "MD5" : "SHA-1";
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(algorithm + " algorithm not available", e);
        }
    }

    @NonNull
    private static UUID buildNamedUuid(@NonNull byte[] data2, int version) {
        data2[6] = (byte)(data2[6] & 0xF);
        data2[6] = (byte)(data2[6] | (byte)(version << 4));
        data2[8] = (byte)(data2[8] & 0x3F);
        data2[8] = (byte)(data2[8] | 0xFFFFFF80);
        return Uuids.fromBytes(data2);
    }

    private static UUID fromBytes(byte[] data2) {
        assert (data2.length >= 16);
        long msb = 0L;
        for (int i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data2[i] & 0xFF);
        }
        long lsb = 0L;
        for (int i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data2[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    private static byte[] toBytes(UUID uuid) {
        byte[] out = new byte[16];
        long msb = uuid.getMostSignificantBits();
        for (int i = 0; i < 8; ++i) {
            out[i] = (byte)(msb >> (7 - i) * 8);
        }
        long lsb = uuid.getLeastSignificantBits();
        for (int i = 8; i < 16; ++i) {
            out[i] = (byte)(lsb >> (15 - i) * 8);
        }
        return out;
    }

    @NonNull
    public static UUID timeBased() {
        return new UUID(Uuids.makeMsb(Uuids.getCurrentTimestamp()), Uuids.CLOCK_SEQ_AND_NODE.get());
    }

    @NonNull
    public static UUID startOf(long timestamp2) {
        return new UUID(Uuids.makeMsb(Uuids.fromUnixTimestamp(timestamp2)), -9187201950435737472L);
    }

    @NonNull
    public static UUID endOf(long timestamp2) {
        long uuidTstamp = Uuids.fromUnixTimestamp(timestamp2 + 1L) - 1L;
        return new UUID(Uuids.makeMsb(uuidTstamp), 0x7F7F7F7F7F7F7F7FL);
    }

    public static long unixTimestamp(@NonNull UUID uuid) {
        if (uuid.version() != 1) {
            throw new IllegalArgumentException(String.format("Can only retrieve the unix timestamp for version 1 uuid (provided version %d)", uuid.version()));
        }
        long timestamp2 = uuid.timestamp();
        return timestamp2 / 10000L + START_EPOCH;
    }

    private static long getCurrentTimestamp() {
        long candidate;
        while (true) {
            long last2;
            long now;
            if ((now = Uuids.fromUnixTimestamp(System.currentTimeMillis())) > (last2 = lastTimestamp.get())) {
                if (!lastTimestamp.compareAndSet(last2, now)) continue;
                return now;
            }
            long lastMillis = Uuids.millisOf(last2);
            if (Uuids.millisOf(now) < Uuids.millisOf(last2)) {
                return lastTimestamp.incrementAndGet();
            }
            candidate = last2 + 1L;
            if (Uuids.millisOf(candidate) == lastMillis && lastTimestamp.compareAndSet(last2, candidate)) break;
        }
        return candidate;
    }

    @VisibleForTesting
    static long fromUnixTimestamp(long tstamp) {
        return (tstamp - START_EPOCH) * 10000L;
    }

    private static long millisOf(long timestamp2) {
        return timestamp2 / 10000L;
    }

    @VisibleForTesting
    static long makeMsb(long timestamp2) {
        long msb = 0L;
        msb |= (0xFFFFFFFFL & timestamp2) << 32;
        msb |= (0xFFFF00000000L & timestamp2) >>> 16;
        msb |= (0xFFF000000000000L & timestamp2) >>> 48;
        return msb |= 0x1000L;
    }

    private static Set<String> getAllLocalAddresses() {
        HashSet<String> allIps = new HashSet<String>();
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            allIps.add(localhost.toString());
            allIps.add(localhost.getCanonicalHostName());
            InetAddress[] allMyIps = InetAddress.getAllByName(localhost.getCanonicalHostName());
            if (allMyIps != null) {
                for (InetAddress allMyIp : allMyIps) {
                    allIps.add(allMyIp.toString());
                }
            }
        }
        catch (UnknownHostException localhost) {
            // empty catch block
        }
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            if (en != null) {
                while (en.hasMoreElements()) {
                    Enumeration<InetAddress> enumIpAddr = en.nextElement().getInetAddresses();
                    while (enumIpAddr.hasMoreElements()) {
                        allIps.add(enumIpAddr.nextElement().toString());
                    }
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return allIps;
    }

    private static class ClockSeqAndNodeContainer {
        private volatile boolean initialized = false;
        private long val;

        private ClockSeqAndNodeContainer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private long get() {
            if (this.initialized) return this.val;
            Class<ClockSeqAndNodeContainer> clazz2 = ClockSeqAndNodeContainer.class;
            synchronized (ClockSeqAndNodeContainer.class) {
                if (this.initialized) return this.val;
                this.initialized = true;
                this.val = Uuids.makeClockSeqAndNode();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.val;
            }
        }
    }
}

