/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.type.reflect;

import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.reflect.GenericTypeParameter;
import com.datastax.oss.driver.shaded.guava.common.primitives.Primitives;
import com.datastax.oss.driver.shaded.guava.common.reflect.TypeParameter;
import com.datastax.oss.driver.shaded.guava.common.reflect.TypeResolver;
import com.datastax.oss.driver.shaded.guava.common.reflect.TypeToken;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.jcip.annotations.Immutable;

@Immutable
public class GenericType<T> {
    public static final GenericType<Boolean> BOOLEAN = GenericType.of(Boolean.class);
    public static final GenericType<Byte> BYTE = GenericType.of(Byte.class);
    public static final GenericType<Double> DOUBLE = GenericType.of(Double.class);
    public static final GenericType<Float> FLOAT = GenericType.of(Float.class);
    public static final GenericType<Integer> INTEGER = GenericType.of(Integer.class);
    public static final GenericType<Long> LONG = GenericType.of(Long.class);
    public static final GenericType<Short> SHORT = GenericType.of(Short.class);
    public static final GenericType<Instant> INSTANT = GenericType.of(Instant.class);
    public static final GenericType<ZonedDateTime> ZONED_DATE_TIME = GenericType.of(ZonedDateTime.class);
    public static final GenericType<LocalDate> LOCAL_DATE = GenericType.of(LocalDate.class);
    public static final GenericType<LocalTime> LOCAL_TIME = GenericType.of(LocalTime.class);
    public static final GenericType<LocalDateTime> LOCAL_DATE_TIME = GenericType.of(LocalDateTime.class);
    public static final GenericType<ByteBuffer> BYTE_BUFFER = GenericType.of(ByteBuffer.class);
    public static final GenericType<String> STRING = GenericType.of(String.class);
    public static final GenericType<BigInteger> BIG_INTEGER = GenericType.of(BigInteger.class);
    public static final GenericType<BigDecimal> BIG_DECIMAL = GenericType.of(BigDecimal.class);
    public static final GenericType<UUID> UUID = GenericType.of(UUID.class);
    public static final GenericType<InetAddress> INET_ADDRESS = GenericType.of(InetAddress.class);
    public static final GenericType<CqlDuration> CQL_DURATION = GenericType.of(CqlDuration.class);
    public static final GenericType<TupleValue> TUPLE_VALUE = GenericType.of(TupleValue.class);
    public static final GenericType<UdtValue> UDT_VALUE = GenericType.of(UdtValue.class);
    public static final GenericType<Duration> DURATION = GenericType.of(Duration.class);
    private final TypeToken<T> token;

    @NonNull
    public static <T> GenericType<T> of(@NonNull Class<T> type) {
        return new SimpleGenericType<T>(type);
    }

    @NonNull
    public static GenericType<?> of(@NonNull Type type) {
        return new GenericType(TypeToken.of(type));
    }

    @NonNull
    public static <T> GenericType<List<T>> listOf(@NonNull Class<T> elementType2) {
        TypeToken token2 = new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, TypeToken.of(elementType2));
        return new GenericType<List<T>>(token2);
    }

    @NonNull
    public static <T> GenericType<List<T>> listOf(@NonNull GenericType<T> elementType2) {
        TypeToken token2 = new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, elementType2.token);
        return new GenericType<List<T>>(token2);
    }

    @NonNull
    public static <T> GenericType<Set<T>> setOf(@NonNull Class<T> elementType2) {
        TypeToken token2 = new TypeToken<Set<T>>(){}.where(new TypeParameter<T>(){}, TypeToken.of(elementType2));
        return new GenericType<Set<T>>(token2);
    }

    @NonNull
    public static <T> GenericType<Set<T>> setOf(@NonNull GenericType<T> elementType2) {
        TypeToken token2 = new TypeToken<Set<T>>(){}.where(new TypeParameter<T>(){}, elementType2.token);
        return new GenericType<Set<T>>(token2);
    }

    @NonNull
    public static <K, V> GenericType<Map<K, V>> mapOf(@NonNull Class<K> keyType, @NonNull Class<V> valueType) {
        TypeToken token2 = new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, TypeToken.of(keyType)).where(new TypeParameter<V>(){}, TypeToken.of(valueType));
        return new GenericType<Map<K, V>>(token2);
    }

    @NonNull
    public static <K, V> GenericType<Map<K, V>> mapOf(@NonNull GenericType<K> keyType, @NonNull GenericType<V> valueType) {
        TypeToken token2 = new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType.token).where(new TypeParameter<V>(){}, valueType.token);
        return new GenericType<Map<K, V>>(token2);
    }

    @NonNull
    public static <T> GenericType<T[]> arrayOf(@NonNull Class<T> componentType) {
        TypeToken token2 = new TypeToken<T[]>(){}.where(new TypeParameter<T>(){}, TypeToken.of(componentType));
        return new GenericType<T[]>(token2);
    }

    @NonNull
    public static <T> GenericType<T[]> arrayOf(@NonNull GenericType<T> componentType) {
        TypeToken token2 = new TypeToken<T[]>(){}.where(new TypeParameter<T>(){}, componentType.token);
        return new GenericType<T[]>(token2);
    }

    @NonNull
    public static <T> GenericType<Optional<T>> optionalOf(@NonNull Class<T> componentType) {
        TypeToken token2 = new TypeToken<Optional<T>>(){}.where(new TypeParameter<T>(){}, TypeToken.of(componentType));
        return new GenericType<Optional<T>>(token2);
    }

    @NonNull
    public static <T> GenericType<Optional<T>> optionalOf(@NonNull GenericType<T> componentType) {
        TypeToken token2 = new TypeToken<Optional<T>>(){}.where(new TypeParameter<T>(){}, componentType.token);
        return new GenericType<Optional<T>>(token2);
    }

    private GenericType(TypeToken<T> token2) {
        this.token = token2;
    }

    protected GenericType() {
        this.token = new TypeToken<T>(this.getClass()){};
    }

    public final boolean isSupertypeOf(@NonNull GenericType<?> type) {
        return this.token.isSupertypeOf(type.token);
    }

    public final boolean isSubtypeOf(@NonNull GenericType<?> type) {
        return this.token.isSubtypeOf(type.token);
    }

    public final boolean isArray() {
        return this.token.isArray();
    }

    public final boolean isPrimitive() {
        return this.token.isPrimitive();
    }

    @NonNull
    public final GenericType<T> wrap() {
        if (this.isPrimitive()) {
            return new GenericType<T>(this.token.wrap());
        }
        return this;
    }

    @NonNull
    public final GenericType<T> unwrap() {
        if (Primitives.allWrapperTypes().contains(this.token.getRawType())) {
            return new GenericType<T>(this.token.unwrap());
        }
        return this;
    }

    @NonNull
    public final <X> GenericType<T> where(@NonNull GenericTypeParameter<X> freeVariable, @NonNull GenericType<X> actualType) {
        TypeResolver resolver = new TypeResolver().where(freeVariable.getTypeVariable(), actualType.__getToken().getType());
        Type resolvedType = resolver.resolveType(this.token.getType());
        TypeToken<?> resolvedToken = TypeToken.of(resolvedType);
        return new GenericType(resolvedToken);
    }

    @NonNull
    public final <X> GenericType<T> where(@NonNull GenericTypeParameter<X> freeVariable, @NonNull Class<X> actualType) {
        return this.where(freeVariable, GenericType.of(actualType));
    }

    @Nullable
    public final GenericType<?> getComponentType() {
        TypeToken<?> componentTypeToken = this.token.getComponentType();
        return componentTypeToken == null ? null : new GenericType(componentTypeToken);
    }

    @NonNull
    public Class<? super T> getRawType() {
        return this.token.getRawType();
    }

    @NonNull
    public final GenericType<? super T> getSupertype(@NonNull Class<? super T> superclass) {
        return new GenericType<T>(this.token.getSupertype(superclass));
    }

    @NonNull
    public final GenericType<? extends T> getSubtype(@NonNull Class<?> subclass) {
        return new GenericType<T>(this.token.getSubtype(subclass));
    }

    @NonNull
    public final Type getType() {
        return this.token.getType();
    }

    @NonNull
    public TypeToken<T> __getToken() {
        return this.token;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof GenericType) {
            GenericType that = (GenericType)other;
            return this.token.equals(that.token);
        }
        return false;
    }

    public int hashCode() {
        return this.token.hashCode();
    }

    public String toString() {
        return this.token.toString();
    }

    private static class SimpleGenericType<T>
    extends GenericType<T> {
        SimpleGenericType(Class<T> type) {
            super(TypeToken.of(type));
        }
    }
}

