/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;

public interface TypeCodec<JavaTypeT> {
    @NonNull
    public GenericType<JavaTypeT> getJavaType();

    @NonNull
    public DataType getCqlType();

    default public boolean accepts(@NonNull GenericType<?> javaType2) {
        Preconditions.checkNotNull(javaType2);
        return this.getJavaType().equals(javaType2.wrap());
    }

    default public boolean accepts(@NonNull Class<?> javaClass) {
        Preconditions.checkNotNull(javaClass);
        if (javaClass.isPrimitive()) {
            if (javaClass == Boolean.TYPE) {
                javaClass = Boolean.class;
            } else if (javaClass == Character.TYPE) {
                javaClass = Character.class;
            } else if (javaClass == Byte.TYPE) {
                javaClass = Byte.class;
            } else if (javaClass == Short.TYPE) {
                javaClass = Short.class;
            } else if (javaClass == Integer.TYPE) {
                javaClass = Integer.class;
            } else if (javaClass == Long.TYPE) {
                javaClass = Long.class;
            } else if (javaClass == Float.TYPE) {
                javaClass = Float.class;
            } else if (javaClass == Double.TYPE) {
                javaClass = Double.class;
            }
        }
        return this.getJavaType().getRawType().equals(javaClass);
    }

    default public boolean accepts(@NonNull Object value2) {
        Preconditions.checkNotNull(value2);
        return this.getJavaType().getRawType().isAssignableFrom(value2.getClass());
    }

    default public boolean accepts(@NonNull DataType cqlType) {
        Preconditions.checkNotNull(cqlType);
        return this.getCqlType().equals(cqlType);
    }

    @Nullable
    public ByteBuffer encode(@Nullable JavaTypeT var1, @NonNull ProtocolVersion var2);

    @Nullable
    public JavaTypeT decode(@Nullable ByteBuffer var1, @NonNull ProtocolVersion var2);

    @NonNull
    public String format(@Nullable JavaTypeT var1);

    @Nullable
    public JavaTypeT parse(@Nullable String var1);
}

